/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.endpoint;

import com.ibm.mqlight.api.ClientOptions;
import com.ibm.mqlight.api.endpoint.Endpoint;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

class EndpointImpl
implements Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(EndpointImpl.class);
    private static final int DEFAULT_IDLE_TIMEOUT = Integer.getInteger("com.ibm.mqlight.api.idleTimeout", 0);
    private final URI uri;
    private String host;
    private int port;
    private boolean useSsl;
    private String user;
    private String password;
    private final int idleTimeout;
    private final ClientOptions.SSLOptions sslOptions;

    protected EndpointImpl(String uri, String user, String password) throws IllegalArgumentException {
        this(uri, user, password, null);
    }

    protected EndpointImpl(String uri, String user, String password, ClientOptions.SSLOptions sslOptions) throws IllegalArgumentException {
        URI serviceUri;
        String methodName = "<init>";
        logger.entry(this, "<init>", uri, user, "******", sslOptions);
        if (user == null && password != null) {
            IllegalArgumentException exception = new IllegalArgumentException("Can't have an empty user ID if you specify a password!");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        if (user != null && password == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Can't have an empty password if you specify a user ID!");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        this.port = 5672;
        this.useSsl = false;
        try {
            String userInfo;
            serviceUri = new URI(uri);
            if (serviceUri.getScheme() == null) {
                IllegalArgumentException exception = new IllegalArgumentException("No scheme in service URI");
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
            String protocol = serviceUri.getScheme().toLowerCase();
            if ("amqps".equals(protocol)) {
                this.port = 5671;
                this.useSsl = true;
            } else if (!"amqp".equals(protocol)) {
                IllegalArgumentException exception = new IllegalArgumentException("Invalid protocol : " + protocol);
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
            if (serviceUri.getHost() == null) {
                IllegalArgumentException exception = new IllegalArgumentException("No host in service URI");
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
            this.host = serviceUri.getHost();
            if (serviceUri.getPort() > -1) {
                this.port = serviceUri.getPort();
            }
            if ((userInfo = serviceUri.getUserInfo()) == null) {
                if (user != null) {
                    this.user = user;
                    this.password = password;
                }
            } else {
                if (user != null) {
                    IllegalArgumentException exception = new IllegalArgumentException("User/password information both specified and in service URI");
                    logger.throwing(this, "<init>", exception);
                    throw exception;
                }
                String[] userInfoSplit = userInfo.split(":");
                if (userInfoSplit.length == 1) {
                    IllegalArgumentException exception = new IllegalArgumentException("If user information is specified in the URI, a password must also be specified");
                    logger.throwing(this, "<init>", exception);
                    throw exception;
                }
                if (userInfoSplit.length > 2) {
                    IllegalArgumentException exception = new IllegalArgumentException("Invalid user/password information in service URI");
                    logger.throwing(this, "<init>", exception);
                    throw exception;
                }
                this.user = userInfoSplit[0];
                if ("".equals(this.user)) {
                    throw new IllegalArgumentException("URI has a password but no user information");
                }
                this.password = userInfoSplit[1];
            }
            if (serviceUri.getPath() != null && serviceUri.getPath().length() > 0 && !serviceUri.getPath().equals("/")) {
                IllegalArgumentException exception = new IllegalArgumentException("Unsupported URL '" + uri + "' paths (" + serviceUri.getPath() + ") can't be part of a service URL");
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
        }
        catch (URISyntaxException e) {
            IllegalArgumentException exception = new IllegalArgumentException("service URI not valid", e);
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        if (sslOptions != null) {
            IllegalArgumentException exception;
            this.validateFileOption("sslTrustCertificate", sslOptions.getTrustCertificateFile());
            this.validateFileOption("sslKeyStore", sslOptions.getKeyStoreFile());
            this.validateFileOption("sslClientCertificate", sslOptions.getClientCertificateFile());
            this.validateFileOption("sslClientKey", sslOptions.getClientKeyFile());
            if (sslOptions.getKeyStoreFile() != null && (sslOptions.getTrustCertificateFile() != null || sslOptions.getClientCertificateFile() != null || sslOptions.getClientKeyFile() != null)) {
                exception = new IllegalArgumentException("The SslKeyStore and other SSL options cannot be specified together");
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
            if (sslOptions.getClientKeyFile() != null && sslOptions.getClientCertificateFile() == null || sslOptions.getClientKeyFile() == null && sslOptions.getClientCertificateFile() != null) {
                exception = new IllegalArgumentException("The SslClientCertificate and SslClientKey options must be specified together");
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
            this.sslOptions = sslOptions;
        } else {
            this.sslOptions = new ClientOptions.SSLOptions(null, null, null, false, null, null, null);
        }
        this.idleTimeout = DEFAULT_IDLE_TIMEOUT;
        this.uri = serviceUri;
        logger.exit(this, "<init>");
    }

    private void validateFileOption(String optionName, File file) {
        String methodName = "validateFileOption";
        logger.entry(this, "validateFileOption", optionName, file);
        if (file != null) {
            if (!file.exists()) {
                IllegalArgumentException exception = new IllegalArgumentException("The file specified for " + optionName + " '" + file.getPath() + "' does not exist");
                logger.throwing(this, "validateFileOption", exception);
                throw exception;
            }
            if (!file.isFile()) {
                IllegalArgumentException exception = new IllegalArgumentException("The file specified for " + optionName + " '" + file.getPath() + "' is not a regular file");
                logger.throwing(this, "validateFileOption", exception);
                throw exception;
            }
        }
        logger.exit(this, "validateFileOption");
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean useSsl() {
        return this.useSsl;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public ClientOptions.SSLOptions getSSLOptions() {
        return this.sslOptions;
    }
}

