/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.endpoint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.ibm.mqlight.api.ClientException;
import com.ibm.mqlight.api.ClientRuntimeException;
import com.ibm.mqlight.api.endpoint.Endpoint;
import com.ibm.mqlight.api.endpoint.EndpointPromise;
import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.impl.endpoint.EndpointImpl;
import com.ibm.mqlight.api.impl.endpoint.EndpointServiceImpl;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class BluemixEndpointService
extends EndpointServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(BluemixEndpointService.class);
    private static final int THREAD_POOL_CORE_THREADS;
    private static final int THREAD_POOL_MAX_THREADS;
    private static final long THREAD_POOL_KEEP_ALIVE_SECONDS;
    private static ThreadPoolExecutor executor;
    private static final Pattern defaultServiceLabelPattern;
    private static final Pattern defaultServiceNamePattern;
    private final Pattern serviceLabelPattern;
    private final Pattern serviceNamePattern;
    private final State state = new State();

    public BluemixEndpointService(Pattern label, Pattern name) {
        this.serviceLabelPattern = label == null ? defaultServiceLabelPattern : label;
        this.serviceNamePattern = name == null ? defaultServiceNamePattern : name;
    }

    protected String getVcapServices() {
        return System.getenv("VCAP_SERVICES");
    }

    protected String getConnectionUriKey() {
        return System.getenv("MQLIGHT_JAVA_BLUEMIX_DISABLE_TLS") == null ? "connectionLookupURI" : "nonTLSConnectionLookupURI";
    }

    protected String hitUri(String httpUri) throws IOException {
        int amount;
        String methodName = "hitUri";
        logger.entry(this, "hitUri", httpUri);
        URL url = new URL(httpUri);
        InputStream in = url.openStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
        String result = out.toString("UTF-8");
        logger.exit(this, "hitUri", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHttpLookup(final String httpUri, final EndpointPromise future) {
        String methodName = "doHttpLookup";
        logger.entry(this, "doHttpLookup", httpUri, future);
        BluemixEndpointService bluemixEndpointService = this;
        synchronized (bluemixEndpointService) {
            if (executor == null) {
                executor = new ThreadPoolExecutor(THREAD_POOL_CORE_THREADS, THREAD_POOL_MAX_THREADS, THREAD_POOL_KEEP_ALIVE_SECONDS, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new BluemixThreadFactory());
            }
        }
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String methodName = "run";
                logger.entry(this, "run");
                try {
                    String serviceJson = BluemixEndpointService.this.hitUri(httpUri);
                    JsonParser parser = new JsonParser();
                    JsonObject root = parser.parse(serviceJson).getAsJsonObject();
                    JsonArray services = root.get("service").getAsJsonArray();
                    Endpoint endpoint = null;
                    1 var7_12 = this;
                    synchronized (var7_12) {
                        ((BluemixEndpointService)BluemixEndpointService.this).state.endpoints = new LinkedList();
                        for (JsonElement serviceElement : services) {
                            String uri = serviceElement.getAsString();
                            ((BluemixEndpointService)BluemixEndpointService.this).state.endpoints.add(new EndpointImpl(uri, ((BluemixEndpointService)BluemixEndpointService.this).state.user, ((BluemixEndpointService)BluemixEndpointService.this).state.password));
                        }
                        if (((BluemixEndpointService)BluemixEndpointService.this).state.endpoints.isEmpty()) {
                            ((BluemixEndpointService)BluemixEndpointService.this).state.endpoints = null;
                            ((BluemixEndpointService)BluemixEndpointService.this).state.nextEndpointIndex = 0;
                        } else {
                            endpoint = ((BluemixEndpointService)BluemixEndpointService.this).state.endpoints.get(0);
                            ((BluemixEndpointService)BluemixEndpointService.this).state.nextEndpointIndex = 1;
                        }
                    }
                    if (endpoint == null) {
                        BluemixEndpointService.this.doRetry(future);
                    } else {
                        future.setSuccess(endpoint);
                    }
                }
                catch (IOException ioException) {
                    logger.data(this, "run", "will retry due to java.io.IOException exception", ioException.getLocalizedMessage());
                    BluemixEndpointService.this.doRetry(future);
                }
                catch (JsonParseException parseException) {
                    ClientException exception = new ClientException("Could not parse the JSON returned by the IBM MQ Light Bluemix lookup service.  See linked exception for more information", parseException);
                    logger.data(this, "run", exception);
                    future.setFailure(exception);
                }
                catch (IllegalArgumentException iae) {
                    ClientException exception = new ClientException("Endpoint information returned by IBM MQ Light Bluemix lookup service was not valid.  See linked exception for more information", iae);
                    logger.data(this, "run", exception);
                    future.setFailure(exception);
                }
                logger.exit(this, "run");
            }
        });
        logger.exit(this, "doHttpLookup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRetry(EndpointPromise future) {
        int retry;
        String methodName = "doRetry";
        logger.entry(this, "doRetry", future);
        State state = this.state;
        synchronized (state) {
            retry = this.state.retryCount++;
        }
        future.setWait(this.calculateDelay(retry));
        logger.exit(this, "doRetry");
    }

    private void parseVCAPJson() throws JsonParseException, ClientException {
        String vcapServices = this.getVcapServices();
        if (vcapServices != null) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(vcapServices).getAsJsonObject();
            HashSet<JsonObject> serviceObjects = new HashSet<JsonObject>();
            for (Map.Entry rootObjectProperty : root.entrySet()) {
                JsonArray arrayOfServices = ((JsonElement)rootObjectProperty.getValue()).getAsJsonArray();
                for (JsonElement serviceElement : arrayOfServices) {
                    JsonObject credentials;
                    JsonObject service = serviceElement.getAsJsonObject();
                    if (!service.has("label") || !this.serviceLabelPattern.matcher(service.get("label").getAsString()).matches() || !service.has("name") || !this.serviceNamePattern.matcher(service.get("name").getAsString()).matches() || "user-provided".equals(service.get("label").getAsString()) && (!((credentials = service.get("credentials").getAsJsonObject()).has("username") ^ credentials.has("user")) || !(credentials.has("connectionLookupURI") ^ credentials.has("mqlight_lookup_url")) || !credentials.has("password"))) continue;
                    serviceObjects.add(service);
                }
            }
            if (serviceObjects.size() > 1) {
                StringBuilder errorMsg = new StringBuilder("Multiple services were found in VCAP_SERVICES. ");
                errorMsg.append("Use the serviceLabel and serviceName methods of BluemixNonBlockingClientBuilder to disambiguate. ");
                errorMsg.append("Candidate services are: [");
                Iterator serviceIterator = serviceObjects.iterator();
                while (serviceIterator.hasNext()) {
                    JsonObject service = (JsonObject)serviceIterator.next();
                    errorMsg.append("label:").append(service.get("label").getAsString()).append("/");
                    errorMsg.append("name:").append(service.get("name").getAsString());
                    if (!serviceIterator.hasNext()) continue;
                    errorMsg.append(", ");
                }
                errorMsg.append("]");
                throw new ClientException(errorMsg.toString());
            }
            if (serviceObjects.size() == 1) {
                JsonObject service = (JsonObject)serviceObjects.iterator().next();
                JsonObject credentials = service.get("credentials").getAsJsonObject();
                this.state.user = credentials.has("username") ? credentials.get("username").getAsString() : credentials.get("user").getAsString();
                this.state.lookupUri = credentials.has("connectionLookupURI") ? credentials.get("connectionLookupURI").getAsString() : credentials.get("mqlight_lookup_url").getAsString();
                this.state.password = credentials.get("password").getAsString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lookup(EndpointPromise future) {
        String methodName = "lookup";
        logger.entry(this, "lookup", future);
        try {
            String lookupUri;
            Endpoint endpoint = null;
            boolean retry = false;
            State state = this.state;
            synchronized (state) {
                if (this.state.lookupUri == null) {
                    this.parseVCAPJson();
                }
                lookupUri = this.state.lookupUri;
                if (this.state.lookupUri != null) {
                    if (this.state.endpoints == null) {
                        this.doHttpLookup(this.state.lookupUri, future);
                    } else if (this.state.nextEndpointIndex >= this.state.endpoints.size()) {
                        this.state.endpoints = null;
                        retry = true;
                    } else {
                        endpoint = this.state.endpoints.get(this.state.nextEndpointIndex++);
                    }
                }
            }
            if (lookupUri == null) {
                ClientException exception = new ClientException("Could not locate a valid IBM Bluemix VCAP_SERVICES environment variable. Check 'service' parameter to NonBlockingClient.create(...) method.");
                logger.data(this, "lookup", exception);
                future.setFailure(exception);
            } else if (retry) {
                this.doRetry(future);
            } else if (endpoint != null) {
                future.setSuccess(endpoint);
            }
        }
        catch (JsonParseException e) {
            ClientException exception = new ClientException("Could not parse the JSON present in the IBM Bluemix VCAP_SERVICES environment variable.  See linked exception for more information", e);
            logger.data(this, "lookup", exception);
            future.setFailure(exception);
        }
        catch (ClientException e) {
            logger.data(this, "lookup", e);
            future.setFailure(e);
        }
        logger.exit(this, "lookup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Endpoint endpoint) {
        String methodName = "onSuccess";
        logger.entry(this, "onSuccess", endpoint);
        State state = this.state;
        synchronized (state) {
            int index = -1;
            if (this.state.endpoints != null) {
                index = this.state.endpoints.indexOf(endpoint);
            }
            if (index == 0) {
                this.state.nextEndpointIndex = 0;
            } else if (index > 0) {
                this.state.endpoints.remove(index);
                this.state.endpoints.addFirst(endpoint);
                this.state.nextEndpointIndex = 0;
            }
        }
        logger.exit(this, "onSuccess");
    }

    static {
        LogbackLogging.setup();
        THREAD_POOL_CORE_THREADS = Integer.getInteger("com.ibm.mqlight.BluemixEndpointService.coreThreads", 5);
        THREAD_POOL_MAX_THREADS = Integer.getInteger("com.ibm.mqlight.BluemixEndpointService.maxThreads", 5);
        THREAD_POOL_KEEP_ALIVE_SECONDS = Integer.getInteger("com.ibm.mqlight.BluemixEndpointService.keepAliveSeconds", 5).intValue();
        logger.data("clinit>", "THREAD_POOL_CORE_THREADS: ", THREAD_POOL_CORE_THREADS);
        logger.data("clinit>", "THREAD_POOL_CORE_THREADS: ", THREAD_POOL_MAX_THREADS);
        logger.data("clinit>", "THREAD_POOL_CORE_THREADS: ", THREAD_POOL_KEEP_ALIVE_SECONDS);
        if (THREAD_POOL_CORE_THREADS <= 0 || THREAD_POOL_CORE_THREADS > THREAD_POOL_MAX_THREADS) {
            throw new ClientRuntimeException("Invalid value (" + THREAD_POOL_CORE_THREADS + ") specified for System property com.ibm.mqlight.BluemixEndpointService.coreThreads (must be > 0 and < the value specified for System property com.ibm.mqlight.BluemixEndpointService.maxThreads, or 5 when com.ibm.mqlight.BluemixEndpointService.maxThreads is not defined.");
        }
        if (THREAD_POOL_KEEP_ALIVE_SECONDS < 0L) {
            throw new ClientRuntimeException("Invalid value (" + THREAD_POOL_KEEP_ALIVE_SECONDS + ")specified for System property com.ibm.mqlight.BluemixEndpointService.keepAliveSeconds (must be >= 0).");
        }
        defaultServiceLabelPattern = Pattern.compile("(mqlight.*)|(messagehub.*)|(user-provided)");
        defaultServiceNamePattern = Pattern.compile(".*");
    }

    private static class BluemixThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger number = new AtomicInteger();

        protected BluemixThreadFactory() {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(this.group, runnable, "bluemix-endpoint-" + this.number.getAndIncrement());
        }
    }

    private static class State {
        String lookupUri;
        int retryCount;
        String user;
        String password;
        LinkedList<Endpoint> endpoints;
        int nextEndpointIndex;

        private State() {
        }
    }
}

