/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.callback;

import com.ibm.mqlight.api.ClientRuntimeException;
import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.callback.CallbackService;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolCallbackService
implements CallbackService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolCallbackService.class);
    private final int poolSize;
    private final WorkList[] workLists;

    public ThreadPoolCallbackService(int poolSize) {
        String methodName = "<init>";
        logger.entry(this, "<init>", poolSize);
        this.poolSize = poolSize;
        this.workLists = new WorkList[poolSize];
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, poolSize, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolCallbackServiceThreadFactory());
        for (int i = 0; i < poolSize; ++i) {
            this.workLists[i] = new WorkList(executor);
        }
        logger.exit(this, "<init>");
    }

    @Override
    public void run(Runnable runnable, Object orderingCtx, Promise<Void> promise) {
        String methodName = "run";
        logger.entry(this, "run", runnable, orderingCtx, promise);
        int hash = orderingCtx.hashCode();
        if (hash == Integer.MIN_VALUE) {
            hash = -2147483647;
        }
        this.workLists[Math.abs(hash) % this.poolSize].put(runnable, promise);
        logger.exit(this, "run");
    }

    static class ThreadPoolCallbackServiceThreadFactory
    implements ThreadFactory {
        final ThreadFactory factory = Executors.defaultThreadFactory();

        ThreadPoolCallbackServiceThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.factory.newThread(r);
            t.setName(ThreadPoolCallbackService.class.getSimpleName() + "-" + t.getName());
            return t;
        }
    }

    private static class WorkList
    implements Runnable {
        private static final Logger logger = LoggerFactory.getLogger(WorkList.class);
        private final ThreadPoolExecutor executor;
        private boolean running = false;
        private final LinkedList<Runnable> runnables = new LinkedList();
        private final LinkedList<Promise<Void>> promises = new LinkedList();

        private WorkList(ThreadPoolExecutor executor) {
            String methodName = "<init>";
            logger.entry(this, "<init>", executor);
            this.executor = executor;
            logger.exit(this, "<init>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String methodName = "run";
            logger.entry(this, "run");
            while (true) {
                Promise<Void> promise;
                Runnable runnable;
                WorkList workList = this;
                synchronized (workList) {
                    if (this.runnables.isEmpty()) {
                        this.running = false;
                        // MONITOREXIT @DISABLED, blocks:[3, 7, 9] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                        logger.exit(this, "run");
                        return;
                    }
                    runnable = this.runnables.removeFirst();
                    promise = this.promises.removeFirst();
                }
                try {
                    runnable.run();
                    promise.setSuccess(null);
                    continue;
                }
                catch (Exception e) {
                    promise.setFailure(e);
                    continue;
                }
                catch (Throwable t) {
                    promise.setFailure(new ClientRuntimeException("Throwable raised during callback", t));
                    WorkList workList2 = this;
                    synchronized (workList2) {
                        if (!this.promises.isEmpty()) {
                            this.executor.submit(this);
                        }
                        throw t;
                    }
                }
                break;
            }
        }

        public synchronized void put(Runnable runnable, Promise<Void> promise) {
            String methodName = "put";
            logger.entry(this, "put", runnable, promise);
            this.runnables.addLast(runnable);
            this.promises.addLast(promise);
            if (!this.running) {
                this.running = true;
                this.executor.submit(this);
            }
            logger.exit(this, "put");
        }
    }
}

