/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.ibm.mqlight.api.impl.network.NettyNetworkService;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;

public class SubscriptionTopic {
    private static final Logger logger = LoggerFactory.getLogger(NettyNetworkService.class);
    private final String topic;
    private final boolean shared;

    public SubscriptionTopic(String topicPattern, String shareName) {
        String subTopic;
        String methodName = "<init>";
        logger.entry(this, "<init>", topicPattern, shareName);
        if (shareName == null || "".equals(shareName)) {
            subTopic = "private:" + topicPattern;
            this.shared = false;
        } else {
            if (shareName.contains(":")) {
                IllegalArgumentException exception = new IllegalArgumentException("Share name cannot contain a colon (:) character");
                logger.throwing(this, "<init>", exception);
                throw exception;
            }
            subTopic = "share:" + shareName + ":" + topicPattern;
            this.shared = true;
        }
        this.topic = subTopic;
        logger.exit(this, "<init>");
    }

    public SubscriptionTopic(String topic) {
        String methodName = "<init>";
        logger.entry(this, "<init>", topic);
        this.topic = topic;
        this.shared = false;
        logger.exit(this, "<init>");
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isShared() {
        return this.shared;
    }

    public String[] split() {
        String topicPattern;
        String share;
        String methodName = "split";
        logger.entry("split");
        if (this.topic.startsWith("share:")) {
            share = this.topic.substring("share:".length());
            topicPattern = share.substring(share.indexOf(58) + 1);
            share = share.substring(0, share.indexOf(58));
        } else {
            topicPattern = this.topic.substring("private:".length());
            share = null;
        }
        String[] result = new String[]{topicPattern, share};
        logger.exit("split", result);
        return result;
    }

    public String toString() {
        return this.topic;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionTopic other = (SubscriptionTopic)obj;
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }
}

