/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.github.oxo42.stateless4j.StateMachine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.mqlight.api.ClientException;
import com.ibm.mqlight.api.ClientOptions;
import com.ibm.mqlight.api.ClientState;
import com.ibm.mqlight.api.CompletionListener;
import com.ibm.mqlight.api.DestinationListener;
import com.ibm.mqlight.api.NetworkException;
import com.ibm.mqlight.api.NonBlockingClient;
import com.ibm.mqlight.api.NonBlockingClientListener;
import com.ibm.mqlight.api.NotPermittedException;
import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.ReplacedException;
import com.ibm.mqlight.api.SecurityException;
import com.ibm.mqlight.api.SendOptions;
import com.ibm.mqlight.api.StartingException;
import com.ibm.mqlight.api.StateException;
import com.ibm.mqlight.api.StoppedException;
import com.ibm.mqlight.api.SubscribeOptions;
import com.ibm.mqlight.api.SubscribedException;
import com.ibm.mqlight.api.UnsubscribedException;
import com.ibm.mqlight.api.callback.CallbackService;
import com.ibm.mqlight.api.endpoint.Endpoint;
import com.ibm.mqlight.api.endpoint.EndpointService;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.DestinationListenerWrapper;
import com.ibm.mqlight.api.impl.FSMActions;
import com.ibm.mqlight.api.impl.InternalSend;
import com.ibm.mqlight.api.impl.InternalStart;
import com.ibm.mqlight.api.impl.InternalStop;
import com.ibm.mqlight.api.impl.InternalSubscribe;
import com.ibm.mqlight.api.impl.InternalUnsubscribe;
import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.impl.Message;
import com.ibm.mqlight.api.impl.NonBlockingClientListenerWrapper;
import com.ibm.mqlight.api.impl.NonBlockingClientState;
import com.ibm.mqlight.api.impl.NonBlockingClientTrigger;
import com.ibm.mqlight.api.impl.NonBlockingFSMFactory;
import com.ibm.mqlight.api.impl.QueueableWork;
import com.ibm.mqlight.api.impl.SubscriptionTopic;
import com.ibm.mqlight.api.impl.callback.CallbackExceptionNotification;
import com.ibm.mqlight.api.impl.callback.CallbackPromiseImpl;
import com.ibm.mqlight.api.impl.callback.FlushResponse;
import com.ibm.mqlight.api.impl.callback.ThreadPoolCallbackService;
import com.ibm.mqlight.api.impl.endpoint.BluemixEndpointService;
import com.ibm.mqlight.api.impl.endpoint.EndpointPromiseImpl;
import com.ibm.mqlight.api.impl.endpoint.EndpointResponse;
import com.ibm.mqlight.api.impl.endpoint.ExhaustedResponse;
import com.ibm.mqlight.api.impl.endpoint.SingleEndpointService;
import com.ibm.mqlight.api.impl.engine.CloseRequest;
import com.ibm.mqlight.api.impl.engine.CloseResponse;
import com.ibm.mqlight.api.impl.engine.DeliveryRequest;
import com.ibm.mqlight.api.impl.engine.DeliveryResponse;
import com.ibm.mqlight.api.impl.engine.DisconnectNotification;
import com.ibm.mqlight.api.impl.engine.DrainNotification;
import com.ibm.mqlight.api.impl.engine.Engine;
import com.ibm.mqlight.api.impl.engine.EngineConnection;
import com.ibm.mqlight.api.impl.engine.OpenRequest;
import com.ibm.mqlight.api.impl.engine.OpenResponse;
import com.ibm.mqlight.api.impl.engine.SendRequest;
import com.ibm.mqlight.api.impl.engine.SendResponse;
import com.ibm.mqlight.api.impl.engine.SubscribeRequest;
import com.ibm.mqlight.api.impl.engine.SubscribeResponse;
import com.ibm.mqlight.api.impl.engine.UnsubscribeRequest;
import com.ibm.mqlight.api.impl.engine.UnsubscribeResponse;
import com.ibm.mqlight.api.impl.network.NettyNetworkService;
import com.ibm.mqlight.api.impl.timer.CancelResponse;
import com.ibm.mqlight.api.impl.timer.PopResponse;
import com.ibm.mqlight.api.impl.timer.TimerPromiseImpl;
import com.ibm.mqlight.api.impl.timer.TimerServiceImpl;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.network.NetworkService;
import com.ibm.mqlight.api.timer.TimerService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;

public class NonBlockingClientImpl
extends NonBlockingClient
implements FSMActions,
Component,
CallbackService {
    private static final Logger logger;
    private final EndpointService endpointService;
    private final CallbackService callbackService;
    private final ComponentImpl engine;
    private final TimerService timer;
    private final GsonBuilder gsonBuilder;
    private final Gson gson;
    private final StateMachine<NonBlockingClientState, NonBlockingClientTrigger> stateMachine;
    static final Class<?>[] validPropertyValueTypes;
    private final LinkedList<InternalStart<?>> pendingStarts = new LinkedList();
    private final LinkedList<InternalStop<?>> pendingStops = new LinkedList();
    private final String clientId;
    private TimerPromiseImpl timerPromise = null;
    private final LinkedList<QueueableWork> pendingWork = new LinkedList();
    private volatile String serviceUri = null;
    private Endpoint currentEndpoint = null;
    private EngineConnection currentConnection = null;
    private final Map<SendRequest, InternalSend<?>> outstandingSends = new HashMap();
    private final NonBlockingClientListenerWrapper<?> clientListener;
    private boolean remakingInboundLinks = false;
    private int undrainedSends = 0;
    private boolean pendingDrain = false;
    private boolean stoppedByUser = false;
    private ClientException lastException = null;
    long retryDelay = 0L;
    private final HashMap<SubscriptionTopic, SubData> subscribedDestinations = new HashMap();
    private volatile ClientState externalState = ClientState.STARTING;
    private final ComponentImpl component = new ComponentImpl(){

        @Override
        protected void onReceive(Message message) {
            NonBlockingClientImpl.this.onReceive(message);
        }
    };

    protected String generateClientId() {
        SecureRandom sr = new SecureRandom();
        String i = Integer.toHexString(sr.nextInt());
        while (i.length() < 8) {
            i = "0" + i;
        }
        return "AUTO_" + i.substring(0, 7);
    }

    protected <T> NonBlockingClientImpl(EndpointService endpointService, CallbackService callbackService, ComponentImpl engine, TimerService timerService, GsonBuilder gsonBuilder, ClientOptions options, NonBlockingClientListener<T> listener, T context) {
        String methodName = "<init>";
        logger.entry(this, "<init>", callbackService, engine, timerService, gsonBuilder, options, listener, context);
        if (endpointService == null) {
            IllegalArgumentException exception = new IllegalArgumentException("EndpointService cannot be null");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        if (callbackService == null) {
            IllegalArgumentException exception = new IllegalArgumentException("CallbackService cannot be null");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        if (timerService == null) {
            IllegalArgumentException exception = new IllegalArgumentException("TimerService cannot be null");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        if (context instanceof NonBlockingClientListener) {
            IllegalArgumentException exception = new IllegalArgumentException("context cannot be of type NonBlockingClientListener");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        this.endpointService = endpointService;
        this.callbackService = callbackService;
        this.engine = engine;
        this.timer = timerService;
        this.gsonBuilder = gsonBuilder == null ? new GsonBuilder() : gsonBuilder;
        this.gson = this.gsonBuilder.create();
        if (options == null) {
            options = defaultClientOptions;
        }
        this.clientId = options.getId() != null ? options.getId() : this.generateClientId();
        logger.setClientId(this.clientId);
        this.clientListener = new NonBlockingClientListenerWrapper<T>(this, listener, context);
        this.stateMachine = NonBlockingFSMFactory.newStateMachine(this);
        endpointService.lookup(new EndpointPromiseImpl(this));
        logger.exit(this, "<init>");
    }

    public <T> NonBlockingClientImpl(EndpointService endpointService, CallbackService callbackService, NetworkService networkService, TimerService timerService, GsonBuilder gsonBuilder, ClientOptions options, NonBlockingClientListener<T> listener, T context) {
        this(endpointService, callbackService, new Engine(networkService, timerService), timerService, gsonBuilder, options, listener, context);
    }

    public <T> NonBlockingClientImpl(String service, ClientOptions options, NonBlockingClientListener<T> listener, T context) {
        this((EndpointService)(service == null ? new BluemixEndpointService(null, null) : new SingleEndpointService(service, options == null ? null : options.getUser(), options == null ? null : options.getPassword(), options == null ? null : options.getSSLOptions())), (CallbackService)new ThreadPoolCallbackService(5), new NettyNetworkService(), (TimerService)new TimerServiceImpl(), null, options, listener, context);
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    @Override
    public String getService() {
        return this.serviceUri;
    }

    @Override
    public ClientState getState() {
        return this.externalState;
    }

    @Override
    public <T> boolean send(String topic, String data, Map<String, Object> properties, SendOptions sendOptions, CompletionListener<T> listener, T context) throws StoppedException {
        String methodName = "send";
        logger.entry(this, "send", topic, data, properties, sendOptions, listener, context);
        if (data == null) {
            IllegalArgumentException exception = new IllegalArgumentException("data cannot be null");
            logger.throwing(this, "send", exception);
            throw exception;
        }
        org.apache.qpid.proton.message.Message protonMsg = Proton.message();
        protonMsg.setBody(new AmqpValue(data));
        boolean result = this.send(topic, protonMsg, properties, sendOptions == null ? defaultSendOptions : sendOptions, listener, context);
        logger.exit(this, "send", result);
        return result;
    }

    @Override
    public <T> boolean send(String topic, ByteBuffer data, Map<String, Object> properties, SendOptions sendOptions, CompletionListener<T> listener, T context) throws StoppedException {
        String methodName = "send";
        logger.entry(this, "send", topic, data, properties, sendOptions, listener, context);
        if (data == null) {
            IllegalArgumentException exception = new IllegalArgumentException("data cannot be null");
            logger.throwing(this, "send", exception);
            throw exception;
        }
        org.apache.qpid.proton.message.Message protonMsg = Proton.message();
        int pos = data.position();
        byte[] dataBytes = new byte[data.remaining()];
        data.get(dataBytes);
        data.position(pos);
        protonMsg.setBody(new AmqpValue(new Binary(dataBytes)));
        boolean result = this.send(topic, protonMsg, properties, sendOptions == null ? defaultSendOptions : sendOptions, listener, context);
        logger.exit(this, "send", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean send(String topic, Object json, Map<String, Object> properties, SendOptions sendOptions, CompletionListener<T> listener, T context) throws StoppedException {
        String jsonString;
        String methodName = "send";
        logger.entry(this, "send", topic, json, properties, sendOptions, listener, context);
        Gson gson = this.gson;
        synchronized (gson) {
            jsonString = this.gson.toJson(json);
        }
        boolean result = this.sendJson(topic, jsonString, properties, sendOptions, listener, context);
        logger.exit(this, "send", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean send(String topic, Object json, Type type, Map<String, Object> properties, SendOptions sendOptions, CompletionListener<T> listener, T context) throws StoppedException {
        String jsonString;
        String methodName = "send";
        logger.entry(this, "send", topic, json, type, properties, sendOptions, listener, context);
        Gson gson = this.gson;
        synchronized (gson) {
            jsonString = this.gson.toJson(json, type);
        }
        boolean result = this.sendJson(topic, jsonString, properties, sendOptions, listener, context);
        logger.exit(this, "send", result);
        return result;
    }

    @Override
    public <T> boolean sendJson(String topic, String json, Map<String, Object> properties, SendOptions sendOptions, CompletionListener<T> listener, T context) throws StoppedException {
        String methodName = "sendJson";
        logger.entry(this, "sendJson", topic, json, properties, sendOptions, listener, context);
        org.apache.qpid.proton.message.Message protonMsg = Proton.message();
        protonMsg.setBody(new AmqpValue(json));
        protonMsg.setContentType("application/json");
        boolean result = this.send(topic, protonMsg, properties, sendOptions == null ? defaultSendOptions : sendOptions, listener, context);
        logger.exit(this, "sendJson", result);
        return result;
    }

    protected static boolean isValidPropertyValue(Object value) {
        String methodName = "isValidPropertyValue";
        logger.entry("isValidPropertyValue", value);
        if (value == null) {
            logger.exit("isValidPropertyValue", true);
            return true;
        }
        for (Class<?> validPropertyValueType : validPropertyValueTypes) {
            if (!validPropertyValueType.isAssignableFrom(value.getClass())) continue;
            logger.exit("isValidPropertyValue", true);
            return true;
        }
        logger.exit("isValidPropertyValue", false);
        return false;
    }

    private <T> boolean send(String topic, org.apache.qpid.proton.message.Message protonMsg, Map<String, Object> properties, SendOptions sendOptions, CompletionListener<T> listener, T context) throws StoppedException {
        int length;
        String methodName = "send";
        logger.entry(this, "send", topic, protonMsg, properties, sendOptions, listener, context);
        if (topic == null) {
            IllegalArgumentException exception = new IllegalArgumentException("topic cannot be null");
            logger.throwing(this, "send", exception);
            throw exception;
        }
        protonMsg.setAddress("amqp:///" + topic);
        protonMsg.setTtl(sendOptions.getTtl());
        HashMap<String, Object> amqpProperties = new HashMap<String, Object>();
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                if (!NonBlockingClientImpl.isValidPropertyValue(entry.getValue())) {
                    IllegalArgumentException exception = new IllegalArgumentException("Property key '" + entry.getKey() + "' specifies a value '" + (entry.getValue() == null ? "null" : entry.getValue().toString()) + "' which is not of a supported type");
                    logger.throwing(this, "send", exception);
                    throw exception;
                }
                if (entry.getValue() instanceof Byte[]) {
                    Byte[] src = (Byte[])entry.getValue();
                    byte[] copy = new byte[src.length];
                    for (int i = 0; i < src.length; ++i) {
                        Byte b = src[i];
                        copy[i] = b == null ? (byte)0 : b;
                    }
                    amqpProperties.put(entry.getKey(), new Binary(copy));
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    byte[] copy = new byte[((byte[])entry.getValue()).length];
                    System.arraycopy(entry.getValue(), 0, copy, 0, copy.length);
                    amqpProperties.put(entry.getKey(), new Binary(copy));
                    continue;
                }
                amqpProperties.put(entry.getKey(), entry.getValue());
            }
            protonMsg.setApplicationProperties(new ApplicationProperties(amqpProperties));
        }
        byte[] data = new byte[2048];
        while (true) {
            try {
                length = protonMsg.encode(data, 0, data.length);
            }
            catch (BufferOverflowException boe) {
                data = new byte[data.length * 2];
                continue;
            }
            break;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        InternalSend is = new InternalSend(this, topic, sendOptions.getQos(), buf, length, sendOptions.getRetainLink());
        ++this.undrainedSends;
        this.tell(is, this);
        try {
            is.future.setListener(this.callbackService, listener, context);
        }
        catch (StoppedException e) {
            logger.throwing(this, "send", e);
            throw e;
        }
        catch (StateException e) {
            IllegalStateException exception = new IllegalStateException("Unexpected state exception", e);
            logger.ffdc("send", FFDCProbeId.PROBE_001, exception, this);
            logger.throwing(this, "send", e);
            throw exception;
        }
        boolean result = this.undrainedSends < 2;
        this.pendingDrain |= !result;
        logger.exit(this, "send", result);
        return result;
    }

    @Override
    public <T> NonBlockingClient start(CompletionListener<T> listener, T context) throws StoppedException {
        String methodName = "start";
        logger.entry(this, "start", listener, context);
        InternalStart is = new InternalStart(this);
        try {
            is.future.setListener(this.callbackService, listener, context);
        }
        catch (StoppedException e) {
            logger.throwing(this, "start", e);
            throw e;
        }
        catch (StateException e) {
            IllegalStateException exception = new IllegalStateException("Unexpected state exception", e);
            logger.ffdc("start", FFDCProbeId.PROBE_002, exception, this);
            logger.throwing(this, "start", e);
            throw exception;
        }
        this.tell(is, this);
        logger.entry(this, "start", this);
        return this;
    }

    @Override
    public <T> void stop(CompletionListener<T> listener, T context) throws StartingException {
        String methodName = "stop";
        logger.entry(this, "stop", listener, context);
        InternalStop is = new InternalStop(this);
        try {
            is.future.setListener(this.callbackService, listener, context);
        }
        catch (StartingException e) {
            logger.throwing(this, "stop", e);
            throw e;
        }
        catch (StateException e) {
            IllegalStateException exception = new IllegalStateException("Unexpected state exception", e);
            logger.ffdc("stop", FFDCProbeId.PROBE_003, exception, this);
            logger.throwing(this, "stop", e);
            throw exception;
        }
        this.tell(is, this);
        logger.exit(this, "stop");
    }

    @Override
    public <T> NonBlockingClient subscribe(String topicPattern, SubscribeOptions subOptions, DestinationListener<T> destListener, CompletionListener<T> compListener, T context) throws SubscribedException, StoppedException, IllegalArgumentException {
        String methodName = "subscribe";
        logger.entry(this, "subscribe", topicPattern, subOptions, destListener, compListener, context);
        if (topicPattern == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Topic pattern cannot be null");
            logger.throwing(this, "subscribe", exception);
            throw exception;
        }
        if (destListener == null) {
            IllegalArgumentException exception = new IllegalArgumentException("DestinationListener cannot be null");
            logger.throwing(this, "subscribe", exception);
            throw exception;
        }
        if (subOptions == null) {
            subOptions = defaultSubscribeOptions;
        }
        SubscriptionTopic subTopic = new SubscriptionTopic(topicPattern, subOptions.getShareName());
        boolean autoConfirm = subOptions.getAutoConfirm() || subOptions.getQOS() == QOS.AT_MOST_ONCE;
        InternalSubscribe<T> is = new InternalSubscribe<T>(this, subTopic, subOptions.getQOS(), subOptions.getCredit(), autoConfirm, Math.round((double)subOptions.getTtl() / 1000.0), this.gsonBuilder, destListener, context);
        this.tell(is, this);
        try {
            is.future.setListener(this.callbackService, compListener, context);
        }
        catch (StoppedException | SubscribedException e) {
            logger.throwing(this, "subscribe", e);
            throw e;
        }
        catch (StateException e) {
            IllegalStateException exception = new IllegalStateException("Unexpected state exception", e);
            logger.ffdc("subscribe", FFDCProbeId.PROBE_004, exception, this);
            logger.throwing(this, "subscribe", e);
            throw exception;
        }
        logger.exit(this, "subscribe", this);
        return this;
    }

    @Override
    public <T> NonBlockingClient unsubscribe(String topicPattern, String share, int ttl, CompletionListener<T> listener, T context) throws UnsubscribedException, StoppedException, IllegalArgumentException {
        String methodName = "unsubscribe";
        logger.entry(this, "unsubscribe", topicPattern, share, ttl, listener, context);
        if (topicPattern == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Topic pattern cannot be null");
            logger.throwing(this, "unsubscribe", exception);
            throw exception;
        }
        if (share != null && share.contains(":")) {
            IllegalArgumentException exception = new IllegalArgumentException("Share name cannot contain a colon (:) character");
            logger.throwing(this, "unsubscribe", exception);
            throw exception;
        }
        if (ttl != 0) {
            IllegalArgumentException exception = new IllegalArgumentException("TTL cannot be non-zero");
            logger.throwing(this, "unsubscribe", exception);
            throw exception;
        }
        InternalUnsubscribe us = new InternalUnsubscribe(this, topicPattern, share, true);
        this.tell(us, this);
        try {
            us.future.setListener(this.callbackService, listener, context);
        }
        catch (StoppedException | UnsubscribedException e) {
            logger.throwing(this, "unsubscribe", e);
            throw e;
        }
        catch (StateException e) {
            IllegalStateException exception = new IllegalStateException("Unexpected state exception", e);
            logger.ffdc("unsubscribe", FFDCProbeId.PROBE_005, exception, this);
            logger.throwing(this, "unsubscribe", e);
            throw exception;
        }
        logger.exit(this, "unsubscribe", this);
        return this;
    }

    @Override
    public <T> NonBlockingClient unsubscribe(String topicPattern, String share, CompletionListener<T> listener, T context) throws UnsubscribedException, StoppedException {
        String methodName = "unsubscribe";
        logger.entry(this, "unsubscribe", topicPattern, share, listener, context);
        if (topicPattern == null) {
            IllegalArgumentException exception = new IllegalArgumentException("Topic pattern cannot be null");
            logger.throwing(this, "unsubscribe", exception);
            throw exception;
        }
        if (share != null && share.contains(":")) {
            IllegalArgumentException exception = new IllegalArgumentException("Share name cannot contain a colon (:) character");
            logger.throwing(this, "unsubscribe", exception);
            throw exception;
        }
        InternalUnsubscribe us = new InternalUnsubscribe(this, topicPattern, share, false);
        this.tell(us, this);
        try {
            us.future.setListener(this.callbackService, listener, context);
        }
        catch (StoppedException | UnsubscribedException e) {
            logger.throwing(this, "unsubscribe", e);
            throw e;
        }
        catch (StateException e) {
            IllegalStateException exception = new IllegalStateException("Unexpected state exception", e);
            logger.ffdc("unsubscribe", FFDCProbeId.PROBE_006, exception, this);
            logger.throwing(this, "unsubscribe", e);
            throw exception;
        }
        logger.exit(this, "unsubscribe", this);
        return this;
    }

    protected void onReceive(Message message) {
        String methodName = "onReceive";
        logger.entry(this, "onReceive", message);
        if (message instanceof EndpointResponse) {
            EndpointResponse er = (EndpointResponse)message;
            if (er.exception != null) {
                if (this.lastException == null) {
                    this.lastException = er.exception;
                }
                this.stateMachine.fire((Object)NonBlockingClientTrigger.EP_RESP_FATAL);
            } else {
                this.currentEndpoint = er.endpoint;
                this.stateMachine.fire((Object)NonBlockingClientTrigger.EP_RESP_OK);
            }
        } else if (message instanceof ExhaustedResponse) {
            this.retryDelay = ((ExhaustedResponse)message).delay;
            this.stateMachine.fire((Object)NonBlockingClientTrigger.EP_RESP_EXHAUSTED);
        } else if (message instanceof OpenResponse) {
            OpenResponse or = (OpenResponse)message;
            if (or.exception != null) {
                if (this.lastException == null) {
                    this.lastException = or.exception;
                }
                if (or.exception instanceof ReplacedException || or.exception instanceof NotPermittedException || or.exception instanceof SecurityException) {
                    this.stateMachine.fire((Object)NonBlockingClientTrigger.OPEN_RESP_FATAL);
                } else {
                    this.stateMachine.fire((Object)NonBlockingClientTrigger.OPEN_RESP_RETRY);
                }
            } else {
                this.currentConnection = or.connection;
                this.stateMachine.fire((Object)NonBlockingClientTrigger.OPEN_RESP_OK);
            }
        } else if (message instanceof InternalSend) {
            InternalSend is = (InternalSend)message;
            NonBlockingClientState state = (NonBlockingClientState)((Object)this.stateMachine.getState());
            if (NonBlockingClientState.acceptingWorkStates.contains((Object)state)) {
                SendRequest sr = new SendRequest(this.currentConnection, is.topic, is.buf, is.length, is.qos, is.retainLink);
                this.outstandingSends.put(sr, is);
                this.engine.tell(sr, this);
            } else if (NonBlockingClientState.queueingWorkStates.contains((Object)state)) {
                this.pendingWork.addLast(is);
            } else {
                is.future.setFailure(new StoppedException("Cannot send messages because the client is in stopped state"));
            }
        } else if (message instanceof SendResponse) {
            SendResponse sr = (SendResponse)message;
            sr.request.releaseBuf();
            InternalSend<?> is = this.outstandingSends.remove(sr.request);
            if (is != null) {
                if (sr.cause == null) {
                    is.future.setSuccess(null);
                } else {
                    is.future.setFailure(sr.cause);
                }
            }
        } else if (message instanceof InternalStart) {
            this.pendingStarts.addLast((InternalStart)message);
            this.stateMachine.fire((Object)NonBlockingClientTrigger.START);
        } else if (message instanceof InternalStop) {
            this.pendingStops.addLast((InternalStop)message);
            this.stateMachine.fire((Object)NonBlockingClientTrigger.STOP);
        } else if (message instanceof CloseResponse) {
            this.currentConnection = null;
            this.stateMachine.fire((Object)NonBlockingClientTrigger.CLOSE_RESP);
        } else if (message instanceof PopResponse) {
            this.timerPromise = null;
            this.stateMachine.fire((Object)NonBlockingClientTrigger.TIMER_RESP_POP);
        } else if (message instanceof CancelResponse) {
            this.timerPromise = null;
            this.stateMachine.fire((Object)NonBlockingClientTrigger.TIMER_RESP_CANCEL);
        } else if (message instanceof InternalSubscribe) {
            InternalSubscribe is = (InternalSubscribe)message;
            NonBlockingClientState state = (NonBlockingClientState)((Object)this.stateMachine.getState());
            if (NonBlockingClientState.acceptingWorkStates.contains((Object)state)) {
                SubData sd = this.subscribedDestinations.get(is.topic);
                if (sd == null) {
                    SubscribeRequest sr = new SubscribeRequest(this.currentConnection, is.topic, is.qos, is.credit, is.ttl);
                    sd = new SubData(is.destListener, is.qos, is.credit, is.autoConfirm, is.ttl);
                    sd.inProgressSubscribe = is;
                    sd.state = SubData.State.ATTACHING;
                    this.subscribedDestinations.put(is.topic, sd);
                    this.engine.tell(sr, this);
                } else if (sd.pending.isEmpty()) {
                    if (sd.state == SubData.State.ATTACHING || sd.state == SubData.State.ESTABLISHED) {
                        String[] topicElements = is.topic.split();
                        String errMsg = "Cannot subscribe because the client is already subscribed to topic '" + topicElements[0] + "'";
                        if (topicElements[1] != null) {
                            errMsg = errMsg + " and share '" + topicElements[1] + "'.";
                        }
                        is.future.setFailure(new SubscribedException(errMsg));
                    } else {
                        sd.pending.addLast(is);
                    }
                } else {
                    sd.pending.addLast(is);
                }
            } else if (NonBlockingClientState.queueingWorkStates.contains((Object)state)) {
                this.pendingWork.add(is);
            } else {
                is.future.setFailure(new StoppedException("Cannot subscribe because the client is in stopped state"));
            }
        } else if (message instanceof SubscribeResponse) {
            SubscribeResponse sr = (SubscribeResponse)message;
            SubData sd = this.subscribedDestinations.get(sr.topic);
            if (sr.error == null) {
                if (sd != null) {
                    if (sd.inProgressSubscribe != null) {
                        sd.inProgressSubscribe.future.setSuccess(null);
                        sd.inProgressSubscribe = null;
                    }
                    sd.state = SubData.State.ESTABLISHED;
                    while (!sd.pending.isEmpty()) {
                        Message m = (Message)sd.pending.removeFirst();
                        this.tell(m, m.getSender());
                    }
                    if (this.remakingInboundLinks) {
                        boolean allRemade = true;
                        for (SubData data : this.subscribedDestinations.values()) {
                            if (data.state == SubData.State.ESTABLISHED) continue;
                            allRemade = false;
                            break;
                        }
                        if (allRemade) {
                            this.remakingInboundLinks = false;
                            this.stateMachine.fire((Object)NonBlockingClientTrigger.SUBS_REMADE);
                        }
                    }
                }
            } else if (sd != null) {
                if (sd.inProgressSubscribe != null) {
                    sd.inProgressSubscribe.future.setFailure(sr.error);
                    sd.inProgressSubscribe = null;
                }
                this.subscribedDestinations.remove(sr.topic);
            }
        } else if (message instanceof InternalUnsubscribe) {
            InternalUnsubscribe iu = (InternalUnsubscribe)message;
            SubscriptionTopic amqpTopic = new SubscriptionTopic(iu.topicPattern, iu.share);
            SubData sd = this.subscribedDestinations.get(amqpTopic);
            NonBlockingClientState state = (NonBlockingClientState)((Object)this.stateMachine.getState());
            if (NonBlockingClientState.acceptingWorkStates.contains((Object)state)) {
                if (sd == null) {
                    String errMsg = "Client is not subscribed to topic '" + iu.topicPattern + "'";
                    if (iu.share != null) {
                        errMsg = errMsg + " and share '" + iu.share + "'";
                    }
                    UnsubscribedException se = new UnsubscribedException(errMsg);
                    iu.future.setFailure(se);
                } else if (sd.pending.isEmpty() && sd.pendingDeliveries.isEmpty()) {
                    if (sd.state == SubData.State.ATTACHING) {
                        this.pendingWork.addLast(iu);
                    } else if (sd.state == SubData.State.DETATCHING) {
                        UnsubscribedException se = new UnsubscribedException("Client is not subscribed to " + (iu.share == null || "".equals(iu.share) ? "private" : "shared") + "destination " + iu.topicPattern);
                        iu.future.setFailure(se);
                    } else if (sd.state == SubData.State.ESTABLISHED) {
                        sd.state = SubData.State.DETATCHING;
                        sd.inProgressUnsubscribe = iu;
                        this.engine.tell(new UnsubscribeRequest(this.currentConnection, amqpTopic, iu.zeroTtl), this);
                    }
                } else {
                    sd.pending.addLast(iu);
                }
            } else if (NonBlockingClientState.queueingWorkStates.contains((Object)state)) {
                this.pendingWork.addLast(iu);
            } else {
                iu.future.setFailure(new StoppedException("Cannot unsubscribe because the client is in stopped state"));
            }
        } else if (message instanceof UnsubscribeResponse) {
            UnsubscribeResponse ur = (UnsubscribeResponse)message;
            SubData sd = this.subscribedDestinations.remove(ur.topic);
            if (sd != null) {
                String[] parts = ur.topic.split();
                sd.listener.onUnsubscribed(this.callbackService, parts[0], parts[1], ur.error);
                if (sd.inProgressUnsubscribe != null) {
                    sd.inProgressUnsubscribe.future.setSuccess(null);
                    sd.inProgressUnsubscribe = null;
                }
                while (!sd.pending.isEmpty()) {
                    Message m = (Message)sd.pending.removeFirst();
                    this.tell(m, m.getSender());
                }
                if (this.remakingInboundLinks) {
                    boolean allRemade = true;
                    for (SubData data : this.subscribedDestinations.values()) {
                        if (data.state == SubData.State.ESTABLISHED) continue;
                        allRemade = false;
                        break;
                    }
                    if (allRemade) {
                        this.remakingInboundLinks = false;
                        this.stateMachine.fire((Object)NonBlockingClientTrigger.SUBS_REMADE);
                    }
                }
            }
        } else if (message instanceof DeliveryRequest) {
            DeliveryRequest dr = (DeliveryRequest)message;
            SubData sd = this.subscribedDestinations.get(new SubscriptionTopic(dr.topicPattern));
            if (sd == null) {
                logger.data((Object)"onReceive", "DeliveryRequest: subscribedDestination not found for " + dr.topicPattern);
            } else {
                if (dr.qos == QOS.AT_LEAST_ONCE) {
                    sd.pendingDeliveries.add(dr);
                }
                sd.listener.onDelivery(this.callbackService, dr, sd.qos, sd.autoConfirm);
            }
        } else if (message instanceof DeliveryResponse) {
            DeliveryRequest dr = ((DeliveryResponse)message).request;
            SubData sd = this.subscribedDestinations.get(new SubscriptionTopic(dr.topicPattern));
            if (sd != null) {
                boolean success;
                boolean bl = success = dr.qos == QOS.AT_MOST_ONCE || sd.pendingDeliveries.remove(dr);
                if (!success) {
                    logger.data("Unexpected DeliveryResponse received {} from {} ", dr, message.getSender());
                }
                if (sd.pendingDeliveries.isEmpty()) {
                    while (!sd.pending.isEmpty()) {
                        Message m = (Message)sd.pending.removeFirst();
                        this.tell(m, m.getSender());
                    }
                }
            }
        } else if (message instanceof DisconnectNotification) {
            this.remakingInboundLinks = false;
            DisconnectNotification dn = (DisconnectNotification)message;
            Throwable error = dn.error;
            if (error instanceof ReplacedException) {
                if (this.lastException == null) {
                    this.lastException = (ReplacedException)error;
                }
                this.stateMachine.fire((Object)NonBlockingClientTrigger.REPLACED);
            } else if (error instanceof NotPermittedException) {
                if (this.lastException == null) {
                    this.lastException = (NotPermittedException)error;
                }
                this.stateMachine.fire((Object)NonBlockingClientTrigger.REPLACED);
            } else if (error instanceof SecurityException) {
                if (this.lastException == null) {
                    this.lastException = (SecurityException)error;
                }
                this.stateMachine.fire((Object)NonBlockingClientTrigger.OPEN_RESP_FATAL);
            } else if (error instanceof ClientException) {
                if (this.lastException == null) {
                    this.lastException = (ClientException)error;
                }
                this.stateMachine.fire((Object)NonBlockingClientTrigger.NETWORK_ERROR);
            } else if (error != null) {
                if (this.lastException == null) {
                    this.lastException = new NetworkException(error.getMessage(), error.getCause());
                }
                this.stateMachine.fire((Object)NonBlockingClientTrigger.NETWORK_ERROR);
            }
        } else if (message instanceof FlushResponse) {
            this.stateMachine.fire((Object)NonBlockingClientTrigger.INBOUND_WORK_COMPLETE);
        } else if (message instanceof DrainNotification) {
            this.undrainedSends = 0;
            if (this.pendingDrain) {
                this.pendingDrain = false;
                this.clientListener.onDrain(this.callbackService);
            }
        } else if (message instanceof CallbackExceptionNotification) {
            Exception exception = ((CallbackExceptionNotification)message).exception;
            logger.data(this, "onReceive", "Exception thrown from inside callback", exception);
            logger.error("Exception thrown from inside callback", exception);
            this.stateMachine.fire((Object)NonBlockingClientTrigger.STOP);
            if (this.lastException == null) {
                this.lastException = exception instanceof ClientException ? (ClientException)exception : new ClientException("Exception thrown from inside callback", exception);
            }
        } else {
            logger.data("Unexpected message received {} from {} ", message, message.getSender());
        }
        logger.exit(this, "onReceive");
    }

    @Override
    public void startTimer() {
        String methodName = "startTimer";
        logger.entry(this, "startTimer");
        if (this.timerPromise != null) {
            logger.ffdc("startTimer", FFDCProbeId.PROBE_008, new Exception("timer already active"), this);
        }
        this.timerPromise = new TimerPromiseImpl(this, null);
        this.timer.schedule(this.retryDelay, this.timerPromise);
        logger.exit(this, "startTimer");
    }

    @Override
    public void openConnection() {
        String methodName = "openConnection";
        logger.entry(this, "openConnection");
        this.engine.tell(new OpenRequest(this.currentEndpoint, this.clientId), this);
        logger.exit(this, "openConnection");
    }

    @Override
    public void closeConnection() {
        String methodName = "closeConnection";
        logger.entry(this, "closeConnection");
        for (Map.Entry<SubscriptionTopic, SubData> entry : this.subscribedDestinations.entrySet()) {
            SubData sd = entry.getValue();
            sd.pendingDeliveries.clear();
        }
        this.engine.tell(new CloseRequest(this.currentConnection), this);
        logger.exit(this, "closeConnection");
    }

    @Override
    public void cancelTimer() {
        String methodName = "cancelTimer";
        logger.entry(this, "cancelTimer");
        if (this.timerPromise != null) {
            TimerPromiseImpl tmp = this.timerPromise;
            this.timerPromise = null;
            this.timer.cancel(tmp);
        }
        logger.exit(this, "cancelTimer");
    }

    @Override
    public void requestEndpoint() {
        String methodName = "requestEndpoint";
        logger.entry(this, "requestEndpoint");
        this.endpointService.lookup(new EndpointPromiseImpl(this));
        logger.exit(this, "requestEndpoint");
    }

    @Override
    public void remakeInboundLinks() {
        String methodName = "remakeInboundLinks";
        logger.entry(this, "remakeInboundLinks");
        if (this.subscribedDestinations.isEmpty()) {
            this.stateMachine.fire((Object)NonBlockingClientTrigger.SUBS_REMADE);
        } else {
            this.remakingInboundLinks = true;
            for (Map.Entry<SubscriptionTopic, SubData> entry : this.subscribedDestinations.entrySet()) {
                SubData data = entry.getValue();
                data.state = SubData.State.ATTACHING;
                SubscribeRequest sr = new SubscribeRequest(this.currentConnection, entry.getKey(), data.qos, data.credit, data.ttl);
                this.engine.tell(sr, this);
            }
        }
        logger.exit(this, "remakeInboundLinks");
    }

    @Override
    public void blessEndpoint() {
        String methodName = "blessEndpoint";
        logger.entry(this, "blessEndpoint");
        URI uri = this.currentEndpoint.getURI();
        this.serviceUri = uri == null ? null : uri.toString();
        this.retryDelay = 0L;
        this.endpointService.onSuccess(this.currentEndpoint);
        logger.exit(this, "blessEndpoint");
    }

    @Override
    public void cleanup() {
        String methodName = "cleanup";
        logger.entry(this, "cleanup");
        this.undrainedSends = 0;
        if (this.pendingDrain) {
            this.pendingDrain = false;
            this.clientListener.onDrain(this.callbackService);
        }
        for (Map.Entry<SubscriptionTopic, SubData> entry : this.subscribedDestinations.entrySet()) {
            SubData subData = entry.getValue();
            if (subData.inProgressSubscribe != null) {
                subData.inProgressSubscribe.future.setFailure(new StoppedException("Cannot subscribe because the client is in stopped state"));
                subData.inProgressSubscribe = null;
            }
            if (subData.state == SubData.State.ESTABLISHED) {
                String[] parts = entry.getKey().split();
                subData.listener.onUnsubscribed(this.callbackService, parts[0], parts[1], null);
            }
            if (subData.inProgressUnsubscribe != null) {
                subData.inProgressUnsubscribe.future.setFailure(new StoppedException("Cannot unsubscribe because the client is in stopped state"));
                subData.inProgressUnsubscribe = null;
            }
            subData.pendingDeliveries.clear();
            while (!subData.pending.isEmpty()) {
                this.pendingWork.addLast((QueueableWork)subData.pending.removeFirst());
            }
        }
        this.subscribedDestinations.clear();
        for (InternalSend internalSend : this.outstandingSends.values()) {
            if (internalSend.qos == QOS.AT_MOST_ONCE) {
                internalSend.future.setSuccess(null);
                continue;
            }
            internalSend.future.setFailure(new StoppedException("Cannot send messages because the client is in stopped state"));
        }
        for (QueueableWork queueableWork : this.pendingWork) {
            StoppedException stoppedException;
            Message is;
            if (queueableWork instanceof InternalSend) {
                is = (InternalSend)queueableWork;
                stoppedException = new StoppedException("Cannot send messages because the client is in stopped state");
                is.future.setFailure(stoppedException);
                continue;
            }
            if (queueableWork instanceof InternalSubscribe) {
                is = (InternalSubscribe)queueableWork;
                stoppedException = new StoppedException("Cannot subscribe because the client is in stopped state");
                ((InternalSubscribe)is).future.setFailure(stoppedException);
                continue;
            }
            InternalUnsubscribe iu = (InternalUnsubscribe)queueableWork;
            stoppedException = new StoppedException("Cannot unsubscribe because the client is in stopped state");
            iu.future.setFailure(stoppedException);
        }
        this.timerPromise = null;
        this.currentConnection = null;
        this.remakingInboundLinks = false;
        this.serviceUri = null;
        this.callbackService.run(new Runnable(){

            @Override
            public void run() {
            }
        }, this, new CallbackPromiseImpl(this, false));
        logger.exit(this, "cleanup");
    }

    @Override
    public void failPendingStops() {
        String methodName = "failPendingStops";
        logger.entry(this, "failPendingStops");
        while (!this.pendingStops.isEmpty()) {
            InternalStop<?> stop = this.pendingStops.removeFirst();
            stop.future.setFailure(new StartingException("Cannot stop client because of a subsequent start request"));
        }
        logger.exit(this, "failPendingStops");
    }

    @Override
    public void succeedPendingStops() {
        String methodName = "succeedPendingStops";
        logger.entry(this, "succeedPendingStops");
        while (!this.pendingStops.isEmpty()) {
            InternalStop<?> stop = this.pendingStops.removeFirst();
            stop.future.setSuccess(null);
        }
        logger.exit(this, "succeedPendingStops");
    }

    @Override
    public void failPendingStarts() {
        String methodName = "failPendingStarts";
        logger.entry(this, "failPendingStarts");
        while (!this.pendingStarts.isEmpty()) {
            InternalStart<?> start = this.pendingStarts.removeFirst();
            start.future.setFailure(new StoppedException("Cannot start client because of a subsequent stop request"));
        }
        logger.exit(this, "failPendingStarts");
    }

    @Override
    public void succeedPendingStarts() {
        String methodName = "succeedPendingStarts";
        logger.entry(this, "succeedPendingStarts");
        while (!this.pendingStarts.isEmpty()) {
            InternalStart<?> start = this.pendingStarts.removeFirst();
            start.future.setSuccess(null);
        }
        logger.exit(this, "succeedPendingStarts");
    }

    @Override
    public void processQueuedActions() {
        String methodName = "processQueuedActions";
        logger.entry(this, "processQueuedActions");
        while (!this.pendingWork.isEmpty()) {
            this.tell((Message)((Object)this.pendingWork.removeFirst()), this);
        }
        logger.exit(this, "processQueuedActions");
    }

    @Override
    public void eventStarting() {
        String methodName = "eventStarting";
        logger.entry(this, "eventStarting");
        this.stoppedByUser = false;
        this.lastException = null;
        this.externalState = ClientState.STARTING;
        logger.exit(this, "eventStarting");
    }

    @Override
    public void eventUserStopping() {
        String methodName = "eventUserStopping";
        logger.entry(this, "eventUserStopping");
        this.externalState = ClientState.STOPPING;
        logger.exit(this, "eventUserStopping");
    }

    @Override
    public void eventSystemStopping() {
        String methodName = "eventSystemStopping";
        logger.entry(this, "eventSystemStopping");
        this.externalState = ClientState.STOPPING;
        if (this.lastException == null) {
            this.stoppedByUser = true;
        }
        logger.exit(this, "eventSystemStopping");
    }

    @Override
    public void eventStopped() {
        String methodName = "eventStopped";
        logger.entry(this, "eventStopped");
        this.externalState = ClientState.STOPPED;
        this.clientListener.onStopped(this.callbackService, this.stoppedByUser ? null : this.lastException);
        this.stoppedByUser = false;
        this.lastException = null;
        logger.exit(this, "eventStopped");
    }

    @Override
    public void eventStarted() {
        String methodName = "eventStarted";
        logger.entry(this, "eventStarted");
        this.externalState = ClientState.STARTED;
        this.clientListener.onStarted(this.callbackService);
        logger.exit(this, "eventStarted");
    }

    @Override
    public void eventRetrying() {
        String methodName = "eventRetrying";
        logger.entry(this, "eventRetrying");
        this.externalState = ClientState.RETRYING;
        this.clientListener.onRetrying(this.callbackService, this.stoppedByUser ? null : this.lastException);
        this.lastException = null;
        logger.exit(this, "eventRetrying");
    }

    @Override
    public void eventRestarted() {
        String methodName = "eventRestarted";
        logger.entry(this, "eventRestarted");
        this.externalState = ClientState.STARTED;
        this.clientListener.onRestarted(this.callbackService);
        logger.exit(this, "eventRestarted");
    }

    @Override
    public void breakInboundLinks() {
        String methodName = "breakInboundLinks";
        logger.entry(this, "breakInboundLinks");
        this.undrainedSends = 0;
        if (this.pendingDrain) {
            this.pendingDrain = false;
            this.clientListener.onDrain(this.callbackService);
        }
        for (InternalSend<?> internalSend : this.outstandingSends.values()) {
            if (internalSend.qos == QOS.AT_MOST_ONCE) {
                internalSend.future.setSuccess(null);
                continue;
            }
            this.pendingWork.addLast(internalSend);
        }
        this.outstandingSends.clear();
        for (Map.Entry entry : this.subscribedDestinations.entrySet()) {
            SubData subData = (SubData)entry.getValue();
            subData.pendingDeliveries.clear();
            while (!subData.pending.isEmpty()) {
                this.pendingWork.addLast((QueueableWork)subData.pending.removeFirst());
            }
            subData.state = SubData.State.BROKEN;
        }
        logger.exit(this, "breakInboundLinks");
    }

    protected boolean doDelivery(DeliveryRequest request) {
        String methodName = "doDelivery";
        logger.entry(this, "doDelivery", request);
        SubData sd = this.subscribedDestinations.get(new SubscriptionTopic(request.topicPattern));
        boolean result = false;
        if (sd == null) {
            logger.data((Object)"doDelivery", "subscribedDestination not found for " + request.topicPattern);
        } else {
            boolean bl = result = request.qos == QOS.AT_MOST_ONCE || sd.pendingDeliveries.contains(request);
            if (result) {
                this.engine.tell(new DeliveryResponse(request), this);
            }
        }
        logger.exit(this, "doDelivery", result);
        return result;
    }

    @Override
    public void tell(Message message, Component self) {
        this.component.tell(message, self);
    }

    @Override
    public void run(Runnable runnable, Object orderingCtx, Promise<Void> promise) {
        this.callbackService.run(runnable, orderingCtx, promise);
    }

    static {
        LogbackLogging.setup();
        logger = LoggerFactory.getLogger(NonBlockingClientImpl.class);
        validPropertyValueTypes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, byte[].class, Byte[].class, String.class};
    }

    static class SubData {
        State state = State.ATTACHING;
        private final LinkedList<QueueableWork> pending = new LinkedList();
        private final Set<DeliveryRequest> pendingDeliveries = new HashSet<DeliveryRequest>();
        final DestinationListenerWrapper<?> listener;
        private final QOS qos;
        private final int credit;
        private final boolean autoConfirm;
        private final long ttl;
        InternalSubscribe<?> inProgressSubscribe;
        InternalUnsubscribe<?> inProgressUnsubscribe;

        public SubData(DestinationListenerWrapper<?> listener, QOS qos, int credit, boolean autoConfirm, long ttl) {
            this.listener = listener;
            this.qos = qos;
            this.credit = credit;
            this.autoConfirm = autoConfirm;
            this.ttl = ttl;
        }

        public String toString() {
            return "SubData [state=" + (Object)((Object)this.state) + ", pending=" + this.pending + ", pendingDeliveries=" + this.pendingDeliveries + ", listener=" + this.listener + ", qos=" + (Object)((Object)this.qos) + ", credit=" + this.credit + ", autoConfirm=" + this.autoConfirm + ", ttl=" + this.ttl + ", inProgressSubscribe=" + this.inProgressSubscribe + ", inProgressUnsubscribe=" + this.inProgressUnsubscribe + "]";
        }

        private static enum State {
            BROKEN,
            ATTACHING,
            ESTABLISHED,
            DETATCHING;

        }
    }
}

