/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.google.gson.GsonBuilder;
import com.ibm.mqlight.api.DestinationListener;
import com.ibm.mqlight.api.MalformedDelivery;
import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.callback.CallbackService;
import com.ibm.mqlight.api.impl.BytesDeliveryImpl;
import com.ibm.mqlight.api.impl.DeliveryImpl;
import com.ibm.mqlight.api.impl.JsonDeliveryImpl;
import com.ibm.mqlight.api.impl.MalformedDeliveryImpl;
import com.ibm.mqlight.api.impl.NonBlockingClientImpl;
import com.ibm.mqlight.api.impl.StringDeliveryImpl;
import com.ibm.mqlight.api.impl.SubscriptionTopic;
import com.ibm.mqlight.api.impl.callback.CallbackPromiseImpl;
import com.ibm.mqlight.api.impl.engine.DeliveryRequest;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.message.Message;

class DestinationListenerWrapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(DestinationListenerWrapper.class);
    private final NonBlockingClientImpl client;
    private final GsonBuilder gsonBuilder;
    private final DestinationListener<T> listener;
    private final T context;
    private static final Symbol malformedConditionSymbol = Symbol.getSymbol("x-opt-message-malformed-condition");
    private static final Symbol malformedDescriptionSymbol = Symbol.getSymbol("x-opt-message-malformed-description");
    private static final Symbol malformedMQMDFormatSymbol = Symbol.getSymbol("x-opt-message-malformed-MQMD.Format");
    private static final Symbol malformedMQMDCCSIDSymbol = Symbol.getSymbol("x-opt-message-malformed-MQMD.CodedCharSetId");

    protected DestinationListenerWrapper(NonBlockingClientImpl client, GsonBuilder gsonBuilder, DestinationListener<T> listener, T context) {
        String methodName = "<init>";
        logger.entry(this, "<init>", client, gsonBuilder, listener, context);
        this.client = client;
        this.gsonBuilder = gsonBuilder;
        this.listener = listener;
        this.context = context;
        logger.exit(this, "<init>");
    }

    protected void onUnsubscribed(CallbackService callbackService, final String topicPattern, final String share, final Exception error) {
        String methodName = "onUnsubscribed";
        logger.entry(this, "onUnsubscribed", callbackService, topicPattern, share, error);
        if (this.listener != null) {
            callbackService.run(new Runnable(){

                @Override
                public void run() {
                    DestinationListenerWrapper.this.listener.onUnsubscribed(DestinationListenerWrapper.this.client, DestinationListenerWrapper.this.context, topicPattern, share, error);
                }
            }, this.client, new CallbackPromiseImpl(this.client, true));
        }
        logger.exit(this, "onUnsubscribed");
    }

    protected void onDelivery(CallbackService callbackService, final DeliveryRequest deliveryRequest, final QOS qos, final boolean autoConfirm) {
        String methodName = "onDelivery";
        logger.entry(this, "onDelivery", new Object[]{callbackService, deliveryRequest, qos, autoConfirm});
        callbackService.run(new Runnable(){

            @Override
            public void run() {
                DeliveryImpl delivery;
                String methodName = "run";
                logger.entry(this, "run");
                byte[] data = deliveryRequest.buf;
                deliveryRequest.buf = null;
                MalformedDelivery.MalformedReason malformedReason = null;
                String malformedDescription = null;
                String malformedMQMDFormat = null;
                int malformedMQMDCCSID = 0;
                byte[] payloadBytes = null;
                String payloadString = null;
                boolean payloadIsJson = false;
                Message msg = Proton.message();
                try {
                    msg.decode(data, 0, data.length);
                }
                catch (BufferOverflowException | BufferUnderflowException | DecodeException e) {
                    malformedReason = MalformedDelivery.MalformedReason.PAYLOADNOTAMQP;
                    malformedDescription = "The message could not be decoded because the message data is not a valid AMQP message";
                    payloadBytes = data;
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                if (malformedReason == null) {
                    Object msgBodyValue = ((AmqpValue)msg.getBody()).getValue();
                    if (msgBodyValue instanceof Binary) {
                        Binary binaryValue = (Binary)msgBodyValue;
                        if (binaryValue.getArrayOffset() == 0 && binaryValue.getArray().length == binaryValue.getLength()) {
                            payloadBytes = binaryValue.getArray();
                        } else {
                            payloadBytes = new byte[binaryValue.getLength()];
                            System.arraycopy(binaryValue.getArray(), binaryValue.getArrayOffset(), payloadBytes, 0, binaryValue.getLength());
                        }
                    } else if (msgBodyValue instanceof String) {
                        payloadString = (String)msgBodyValue;
                        payloadIsJson = "application/json".equalsIgnoreCase(msg.getContentType());
                    } else {
                        malformedReason = MalformedDelivery.MalformedReason.FORMATNOMAPPING;
                        malformedDescription = "The message payload uses an AMQP format that the MQ Light client cannot process";
                        payloadBytes = data;
                    }
                    if (msg.getApplicationProperties() != null && msg.getApplicationProperties().getValue() != null) {
                        Map msgMap = msg.getApplicationProperties().getValue();
                        for (Map.Entry entry : msgMap.entrySet()) {
                            if (!(entry.getKey() instanceof String)) continue;
                            Object value = entry.getValue();
                            if (value == null) {
                                properties.put((String)entry.getKey(), null);
                                continue;
                            }
                            if (value instanceof Binary) {
                                properties.put((String)entry.getKey(), ((Binary)value).getArray());
                                continue;
                            }
                            for (int i = 0; i < NonBlockingClientImpl.validPropertyValueTypes.length; ++i) {
                                if (!NonBlockingClientImpl.validPropertyValueTypes[i].isAssignableFrom(value.getClass())) continue;
                                properties.put((String)entry.getKey(), value);
                            }
                        }
                    }
                }
                String[] parts = new SubscriptionTopic(deliveryRequest.topicPattern).split();
                String shareName = parts[1];
                String topicPattern = parts[0];
                long ttl = 0L;
                String topic = "";
                if (malformedReason == null) {
                    Map<Symbol, Object> annotations;
                    try {
                        topic = URI.create(msg.getAddress()).getPath();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (topic == null) {
                        topic = "";
                    } else if (topic.startsWith("/")) {
                        topic = topic.substring(1);
                    }
                    ttl = msg.getTtl();
                    if (msg.getDeliveryAnnotations() != null && (annotations = msg.getDeliveryAnnotations().getValue()).containsKey(malformedConditionSymbol) && annotations.get(malformedConditionSymbol) instanceof Symbol) {
                        String condition = annotations.get(malformedConditionSymbol).toString();
                        if (condition.equals("FORMATNOMAPPING")) {
                            malformedReason = MalformedDelivery.MalformedReason.FORMATNOMAPPING;
                        } else if (condition.equals("JMSNOMAPPING")) {
                            malformedReason = MalformedDelivery.MalformedReason.JMSNOMAPPING;
                        } else if (condition.equals("PAYLOADENCODING")) {
                            malformedReason = MalformedDelivery.MalformedReason.PAYLOADENCODING;
                        } else if (condition.equals("PAYLOADNOTAMQP")) {
                            malformedReason = MalformedDelivery.MalformedReason.PAYLOADNOTAMQP;
                        }
                        if (malformedReason != null && annotations.containsKey(malformedDescriptionSymbol) && annotations.get(malformedDescriptionSymbol) instanceof String) {
                            malformedDescription = (String)annotations.get(malformedDescriptionSymbol);
                            if (annotations.containsKey(malformedMQMDFormatSymbol) && annotations.get(malformedMQMDFormatSymbol) instanceof String) {
                                malformedMQMDFormat = (String)annotations.get(malformedMQMDFormatSymbol);
                            }
                            if (annotations.containsKey(malformedMQMDCCSIDSymbol) && annotations.get(malformedMQMDCCSIDSymbol) instanceof Integer) {
                                malformedMQMDCCSID = (Integer)annotations.get(malformedMQMDCCSIDSymbol);
                            }
                        }
                    }
                }
                if (payloadBytes != null) {
                    if (malformedReason == null) {
                        delivery = new BytesDeliveryImpl(DestinationListenerWrapper.this.client, qos, shareName, topic, topicPattern, ttl, ByteBuffer.wrap(payloadBytes), properties, autoConfirm ? null : deliveryRequest);
                        DestinationListenerWrapper.this.listener.onMessage(DestinationListenerWrapper.this.client, DestinationListenerWrapper.this.context, delivery);
                    } else {
                        delivery = new MalformedDeliveryImpl(DestinationListenerWrapper.this.client, qos, shareName, topic, topicPattern, ttl, ByteBuffer.wrap(payloadBytes), properties, autoConfirm ? null : deliveryRequest, malformedReason, malformedDescription, malformedMQMDFormat, malformedMQMDCCSID);
                        DestinationListenerWrapper.this.listener.onMalformed(DestinationListenerWrapper.this.client, DestinationListenerWrapper.this.context, (MalformedDelivery)((Object)delivery));
                    }
                } else if (malformedReason == null) {
                    delivery = payloadIsJson ? new JsonDeliveryImpl(DestinationListenerWrapper.this.client, qos, shareName, topic, topicPattern, ttl, payloadString, DestinationListenerWrapper.this.gsonBuilder, properties, autoConfirm ? null : deliveryRequest) : new StringDeliveryImpl(DestinationListenerWrapper.this.client, qos, shareName, topic, topicPattern, ttl, payloadString, properties, autoConfirm ? null : deliveryRequest);
                    DestinationListenerWrapper.this.listener.onMessage(DestinationListenerWrapper.this.client, DestinationListenerWrapper.this.context, delivery);
                } else {
                    delivery = new MalformedDeliveryImpl(DestinationListenerWrapper.this.client, qos, shareName, topic, topicPattern, ttl, ByteBuffer.wrap(payloadString.getBytes(Charset.forName("UTF-8"))), properties, autoConfirm ? null : deliveryRequest, malformedReason, malformedDescription, malformedMQMDFormat, malformedMQMDCCSID);
                    DestinationListenerWrapper.this.listener.onMalformed(DestinationListenerWrapper.this.client, DestinationListenerWrapper.this.context, (MalformedDelivery)((Object)delivery));
                }
                if (autoConfirm) {
                    DestinationListenerWrapper.this.client.doDelivery(deliveryRequest);
                }
                logger.exit(this, "run");
            }
        }, this.client, new CallbackPromiseImpl(this.client, true));
        logger.exit(this, "onDelivery");
    }
}

