/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.ibm.mqlight.api.Delivery;
import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.StateException;
import com.ibm.mqlight.api.impl.NonBlockingClientImpl;
import com.ibm.mqlight.api.impl.engine.DeliveryRequest;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.Map;

public abstract class DeliveryImpl
implements Delivery {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryImpl.class);
    private final NonBlockingClientImpl client;
    private final QOS qos;
    private final String share;
    private final String topic;
    private final String topicPattern;
    private final long ttl;
    private final Map<String, Object> properties;
    private final DeliveryRequest deliveryRequest;
    private boolean confirmed = false;

    protected DeliveryImpl(NonBlockingClientImpl client, QOS qos, String share, String topic, String topicPattern, long ttl, Map<String, Object> properties, DeliveryRequest deliveryRequest) {
        String methodName = "<init>";
        logger.entry(this, "<init>", new Object[]{client, qos, share, topic, topicPattern, ttl, properties, deliveryRequest});
        this.client = client;
        this.qos = qos;
        this.share = share;
        this.topic = topic;
        this.topicPattern = topicPattern;
        this.ttl = ttl;
        this.properties = properties;
        this.deliveryRequest = deliveryRequest;
        logger.exit(this, "<init>");
    }

    @Override
    public abstract Delivery.Type getType();

    @Override
    public void confirm() throws StateException {
        String methodName = "confirm";
        logger.entry(this, "confirm");
        if (this.deliveryRequest == null) {
            if (this.qos == QOS.AT_MOST_ONCE) {
                throw new StateException("Confirming the receipt of delivery is applicable only when 'at least once' quality of service has been requested");
            }
            throw new StateException("Subscription has autoConfirm option set to true");
        }
        if (this.confirmed) {
            throw new StateException("Delivery has already been confirmed");
        }
        if (!this.client.doDelivery(this.deliveryRequest)) {
            throw new StateException("Cannot confirm delivery because of an interruption to the network connection to the MQ Light server");
        }
        this.confirmed = true;
        logger.exit(this, "confirm");
    }

    @Override
    public QOS getQOS() {
        return this.qos;
    }

    @Override
    public String getShare() {
        return this.share;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

