/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.ibm.mqlight.api.CompletionListener;
import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.StateException;
import com.ibm.mqlight.api.callback.CallbackService;
import com.ibm.mqlight.api.impl.NonBlockingClientImpl;
import com.ibm.mqlight.api.impl.callback.CallbackPromiseImpl;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;

public class CompletionFuture<T>
implements Promise<T> {
    private static final Logger logger = LoggerFactory.getLogger(CompletionFuture.class);
    private boolean complete = false;
    private final NonBlockingClientImpl client;
    private CompletionListener<T> listener;
    private T context;
    private Exception cause = null;

    public CompletionFuture(NonBlockingClientImpl client) {
        String methodName = "<init>";
        logger.entry(this, "<init>", client);
        this.client = client;
        logger.exit(this, "<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSuccess(T result) throws IllegalStateException {
        T c;
        CompletionListener<T> l;
        String methodName = "postSuccess";
        logger.entry(this, "postSuccess", result);
        CompletionFuture completionFuture = this;
        synchronized (completionFuture) {
            if (this.complete) {
                IllegalStateException ex = new IllegalStateException("Promise already completed");
                logger.throwing(this, "postSuccess", ex);
                throw ex;
            }
            this.complete = true;
            l = this.listener;
            c = this.context;
        }
        if (l != null) {
            this.client.run(new Runnable(){

                @Override
                public void run() {
                    l.onSuccess(CompletionFuture.this.client, c);
                }
            }, this.client, new CallbackPromiseImpl(this.client, true));
        }
        logger.exit(this, "postSuccess");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        T c;
        CompletionListener<T> l;
        String methodName = "postFailure";
        logger.entry(this, "postFailure", exception);
        this.cause = exception;
        CompletionFuture completionFuture = this;
        synchronized (completionFuture) {
            if (this.complete) {
                IllegalStateException ex = new IllegalStateException("Promise already completed");
                logger.throwing(this, "postFailure", ex);
                throw ex;
            }
            this.complete = true;
            l = this.listener;
            c = this.context;
        }
        if (l != null) {
            this.client.run(new Runnable(){

                @Override
                public void run() {
                    l.onError(CompletionFuture.this.client, c, CompletionFuture.this.cause);
                }
            }, this.client, new CallbackPromiseImpl(this.client, true));
        }
        logger.exit(this, "postFailure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(CallbackService callbackService, final CompletionListener<T> listener, final T context) throws StateException {
        String methodName = "setListener";
        logger.entry(this, "setListener", callbackService, listener, context);
        boolean callCallback = false;
        CompletionFuture completionFuture = this;
        synchronized (completionFuture) {
            if (!this.complete) {
                this.listener = listener;
                this.context = context;
            } else {
                callCallback = true;
            }
        }
        if (callCallback) {
            if (this.cause != null) {
                if (this.cause instanceof StateException) {
                    throw (StateException)this.cause;
                }
                if (listener != null) {
                    callbackService.run(new Runnable(){

                        @Override
                        public void run() {
                            listener.onError(CompletionFuture.this.client, context, CompletionFuture.this.cause);
                        }
                    }, this.client, new CallbackPromiseImpl(this.client, true));
                }
            } else if (listener != null) {
                callbackService.run(new Runnable(){

                    @Override
                    public void run() {
                        listener.onSuccess(CompletionFuture.this.client, context);
                    }
                }, this.client, new CallbackPromiseImpl(this.client, true));
            }
        }
        logger.exit(this, "setListener");
    }

    @Override
    public synchronized boolean isComplete() {
        return this.complete;
    }
}

