/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api;

import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.concurrent.TimeUnit;

public class SubscribeOptions {
    private static final Logger logger = LoggerFactory.getLogger(SubscribeOptions.class);
    private final boolean autoConfirm;
    private final int credit;
    private final QOS qos;
    private final String shareName;
    private final long ttl;

    private SubscribeOptions(boolean autoConfirm, int credit, QOS qos, String shareName, long ttl) {
        String methodName = "<init>";
        logger.entry(this, "<init>", new Object[]{autoConfirm, credit, qos, shareName, ttl});
        this.autoConfirm = autoConfirm;
        this.credit = credit;
        this.qos = qos;
        this.shareName = shareName;
        this.ttl = ttl;
        logger.exit(this, "<init>");
    }

    public boolean getAutoConfirm() {
        return this.autoConfirm;
    }

    public int getCredit() {
        return this.credit;
    }

    public QOS getQOS() {
        return this.qos;
    }

    public String getShareName() {
        return this.shareName;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String toString() {
        return super.toString() + " [autoConfirm=" + this.autoConfirm + ", credit=" + this.credit + ", qos=" + (Object)((Object)this.qos) + ", share=" + this.shareName + ", ttl=" + this.ttl + "]";
    }

    public static SubscribeOptionsBuilder builder() {
        return new SubscribeOptionsBuilder();
    }

    public static class SubscribeOptionsBuilder {
        private boolean autoConfirm = true;
        private int credit = 1024;
        private QOS qos = QOS.AT_MOST_ONCE;
        private String shareName = null;
        private long ttl = 0L;

        private SubscribeOptionsBuilder() {
        }

        public SubscribeOptionsBuilder setAutoConfirm(boolean autoConfirm) {
            this.autoConfirm = autoConfirm;
            return this;
        }

        public SubscribeOptionsBuilder setCredit(int credit) throws IllegalArgumentException {
            String methodName = "setCredit";
            logger.entry(this, "setCredit", credit);
            if (credit < 0) {
                IllegalArgumentException exception = new IllegalArgumentException("Credit value '" + credit + "' is invalid, must be >= 0");
                logger.throwing(this, "setCredit", exception);
                throw exception;
            }
            this.credit = credit;
            logger.exit(this, "setCredit", this);
            return this;
        }

        public SubscribeOptionsBuilder setQos(QOS qos) throws IllegalArgumentException {
            String methodName = "setQos";
            logger.entry(this, "setQos", new Object[]{qos});
            if (qos == null) {
                IllegalArgumentException exception = new IllegalArgumentException("QOS value cannot be null");
                logger.throwing(this, "setQos", exception);
                throw exception;
            }
            this.qos = qos;
            logger.exit(this, "setQos", this);
            return this;
        }

        public SubscribeOptionsBuilder setShare(String shareName) throws IllegalArgumentException {
            String methodName = "setShare";
            logger.entry(this, "setShare", shareName);
            if (shareName != null && shareName.contains(":")) {
                IllegalArgumentException exception = new IllegalArgumentException("Share name cannot contain a colon (:) character");
                logger.throwing(this, "setShare", exception);
                throw exception;
            }
            this.shareName = shareName;
            logger.exit(this, "setShare", this);
            return this;
        }

        public SubscribeOptionsBuilder setTtl(long ttl) throws IllegalArgumentException {
            String methodName = "setTtl";
            logger.entry(this, "setTtl", ttl);
            this.setTtl(ttl, TimeUnit.MILLISECONDS);
            logger.exit(this, "setTtl", this);
            return this;
        }

        public SubscribeOptionsBuilder setTtl(long ttl, TimeUnit unit) throws IllegalArgumentException {
            String methodName = "setTtl";
            logger.entry(this, "setTtl", ttl);
            long ttlSeconds = TimeUnit.SECONDS.convert(ttl, unit);
            if (ttl < 0L || ttlSeconds < 0L || ttlSeconds > 0xFFFFFFFFL) {
                IllegalArgumentException exception = new IllegalArgumentException("ttl value " + ttl + " " + unit.toString().toLowerCase() + " is invalid, must be an unsigned 32-bit value when converted to seconds");
                logger.throwing(this, "setTtl", exception);
                throw exception;
            }
            this.ttl = ttl;
            logger.exit(this, "setTtl", this);
            return this;
        }

        public SubscribeOptions build() {
            return new SubscribeOptions(this.autoConfirm, this.credit, this.qos, this.shareName, this.ttl);
        }
    }
}

