/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api;

import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.io.File;

public class ClientOptions {
    private static final Logger logger = LoggerFactory.getLogger(ClientOptions.class);
    private final String id;
    private final String user;
    private final String password;
    private final SSLOptions sslOptions;

    private ClientOptions(String id, String user, String password, SSLOptions sslOptions) {
        String methodName = "<init>";
        logger.entry(this, "<init>", id, user, "******", sslOptions);
        this.id = id;
        this.user = user;
        this.password = password;
        this.sslOptions = sslOptions;
        logger.exit(this, "<init>");
    }

    public String getId() {
        return this.id;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public String toString() {
        return super.toString() + " [id=" + this.id + ", user=" + this.user + ", password=" + (this.password == null ? null : "******") + ", sslOption=" + this.sslOptions.toString() + "]";
    }

    public static ClientOptionsBuilder builder() {
        return new ClientOptionsBuilder();
    }

    public static class ClientOptionsBuilder {
        private String id = null;
        private String user = null;
        private String password = null;
        private File keyStoreFile = null;
        private String keyStoreFilePassphrase = null;
        private File certFile = null;
        private boolean verifyName = true;
        private File clientCertFile = null;
        private File clientKeyFile = null;
        private String clientKeyFilePassphrase = null;

        private ClientOptionsBuilder() {
        }

        public ClientOptionsBuilder setId(String id) throws IllegalArgumentException {
            String methodName = "setId";
            logger.entry(this, "setId", id);
            if (id != null) {
                if (id.length() > 256) {
                    IllegalArgumentException exception = new IllegalArgumentException("Client identifier '" + id + "' is longer than the maximum ID length of 256.");
                    logger.throwing(this, "setId", exception);
                    throw exception;
                }
                if (id.length() < 1) {
                    IllegalArgumentException exception = new IllegalArgumentException("Client identifier must be a minimum ID length of 1.");
                    logger.throwing(this, "setId", exception);
                    throw exception;
                }
                for (int i = 0; i < id.length(); ++i) {
                    if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%/._".contains(id.substring(i, i + 1))) continue;
                    IllegalArgumentException exception = new IllegalArgumentException("Client identifier '" + id + "' contains invalid character: '" + id.substring(i, i + 1) + "'");
                    logger.throwing(this, "setId", exception);
                    throw exception;
                }
            }
            this.id = id;
            logger.exit(this, "setId", this);
            return this;
        }

        public ClientOptionsBuilder setCredentials(String user, String password) {
            this.user = user;
            this.password = password;
            return this;
        }

        public ClientOptionsBuilder setSslKeyStore(File keyStoreFile) {
            String methodName = "setSslKeyStore";
            logger.entry(this, "setSslKeyStore", keyStoreFile);
            if (this.certFile != null || this.clientCertFile != null || this.clientKeyFile != null || this.clientKeyFilePassphrase != null) {
                IllegalArgumentException exception = new IllegalArgumentException("The SSL KeyStore and other SSL options cannot be specified together");
                logger.throwing(this, "setSslKeyStore", exception);
                throw exception;
            }
            this.keyStoreFile = keyStoreFile;
            logger.exit(this, "setSslKeyStore", this);
            return this;
        }

        public ClientOptionsBuilder setSslKeyStorePassphrase(String passphrase) {
            String methodName = "setSslKeyStorePassphrase";
            logger.entry(this, "setSslKeyStorePassphrase", passphrase);
            if (this.certFile != null || this.clientCertFile != null || this.clientKeyFile != null || this.clientKeyFilePassphrase != null) {
                IllegalArgumentException exception = new IllegalArgumentException("The SSL KeyStore and other SSL options cannot be specified together");
                logger.throwing(this, "setSslKeyStorePassphrase", exception);
                throw exception;
            }
            this.keyStoreFilePassphrase = passphrase;
            logger.exit(this, "setSslKeyStorePassphrase", this);
            return this;
        }

        public ClientOptionsBuilder setSslTrustCertificate(File certificateFile) {
            String methodName = "setSslTrustCertificate";
            logger.entry(this, "setSslTrustCertificate", certificateFile);
            if (this.keyStoreFile != null || this.keyStoreFilePassphrase != null) {
                IllegalArgumentException exception = new IllegalArgumentException("The SSL TrustCertificate and KeyStore options cannot be specified together");
                logger.throwing(this, "setSslTrustCertificate", exception);
                throw exception;
            }
            this.certFile = certificateFile;
            logger.exit(this, "setSslTrustCertificate", this);
            return this;
        }

        public ClientOptionsBuilder setSslVerifyName(boolean verifyName) {
            this.verifyName = verifyName;
            return this;
        }

        public ClientOptionsBuilder setSslClientCertificate(File certificateFile) {
            String methodName = "setSslClientCertificate";
            logger.entry(this, "setSslClientCertificate", certificateFile);
            if (this.keyStoreFile != null || this.keyStoreFilePassphrase != null) {
                IllegalArgumentException exception = new IllegalArgumentException("The SSL ClientCertificateFile and KeyStore options cannot be specified together");
                logger.throwing(this, "setSslClientCertificate", exception);
                throw exception;
            }
            this.clientCertFile = certificateFile;
            logger.exit(this, "setSslClientCertificate", this);
            return this;
        }

        public ClientOptionsBuilder setSslClientKey(File keyFile) {
            String methodName = "setSslClientKey";
            logger.entry(this, "setSslClientKey", keyFile);
            if (this.keyStoreFile != null || this.keyStoreFilePassphrase != null) {
                IllegalArgumentException exception = new IllegalArgumentException("The SSL ClientKeyFile and KeyStore options cannot be specified together");
                logger.throwing(this, "setSslClientKey", exception);
                throw exception;
            }
            this.clientKeyFile = keyFile;
            logger.exit(this, "setSslClientKey", this);
            return this;
        }

        public ClientOptionsBuilder setSslClientKeyPassphrase(String passphrase) {
            String methodName = "setSslClientKeyPassphrase";
            logger.entry(this, "setSslClientKeyPassphrase", passphrase);
            if (this.keyStoreFile != null || this.keyStoreFilePassphrase != null) {
                IllegalArgumentException exception = new IllegalArgumentException("The SSL ClientKeyPassphrase and KeyStore options cannot be specified together");
                logger.throwing(this, "setSslClientKeyPassphrase", exception);
                throw exception;
            }
            this.clientKeyFilePassphrase = passphrase;
            logger.exit(this, "setSslClientKeyPassphrase", this);
            return this;
        }

        public ClientOptions build() {
            SSLOptions sslOptions = new SSLOptions(this.keyStoreFile, this.keyStoreFilePassphrase, this.certFile, this.verifyName, this.clientCertFile, this.clientKeyFile, this.clientKeyFilePassphrase);
            return new ClientOptions(this.id, this.user, this.password, sslOptions);
        }
    }

    public static class SSLOptions {
        private final File keyStoreFile;
        private final String keyStoreFilePassphrase;
        private final File trustCertFile;
        private final boolean verifyName;
        private final File clientCertFile;
        private final File clientKeyFile;
        private final String clientKeyFilePassphrase;

        public SSLOptions(File keyStoreFile, String keyStoreFilePassphrase, File certFile, boolean verifyName, File clientCertFile, File clientKeyFile, String clientKeyFilePassphrase) {
            this.keyStoreFile = keyStoreFile;
            this.keyStoreFilePassphrase = keyStoreFilePassphrase;
            this.trustCertFile = certFile;
            this.verifyName = verifyName;
            this.clientCertFile = clientCertFile;
            this.clientKeyFile = clientKeyFile;
            this.clientKeyFilePassphrase = clientKeyFilePassphrase;
        }

        public File getKeyStoreFile() {
            return this.keyStoreFile;
        }

        public String getKeyStoreFilePassphrase() {
            return this.keyStoreFilePassphrase;
        }

        public File getTrustCertificateFile() {
            return this.trustCertFile;
        }

        public boolean getVerifyName() {
            return this.verifyName;
        }

        public File getClientCertificateFile() {
            return this.clientCertFile;
        }

        public File getClientKeyFile() {
            return this.clientKeyFile;
        }

        public String getClientKeyFilePassphrase() {
            return this.clientKeyFilePassphrase;
        }

        public String toString() {
            return super.toString() + " [keyStoreFile=" + this.keyStoreFile + ", keyStoreFilePassphrase=" + (this.keyStoreFilePassphrase == null ? null : "******") + ", certFile=" + this.trustCertFile + ", verifyName=" + this.verifyName + ", clientCertFile=" + this.clientCertFile + ", clientKeyFile=" + this.clientKeyFile + ", clientKeyFilePassphrase=" + (this.clientKeyFilePassphrase == null ? null : "******") + "]";
        }
    }
}

