/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.AddingMultipleSubscribersRequest;
import io.swagger.client.model.AddingMultipleSubscribersResponse;
import io.swagger.client.model.AddingSubscribersRequest;
import io.swagger.client.model.AddingSubscribersResponse;
import io.swagger.client.model.GetSubscriberByEmailAddressResponse;
import io.swagger.client.model.GetSubscriberByIdResponse;
import io.swagger.client.model.GettingSubscribersResponse;
import io.swagger.client.model.RemovingASubscriberRequest;
import io.swagger.client.model.RemovingASubscriberResponse;
import io.swagger.client.model.RemovingMultipleSubscribersRequest;
import io.swagger.client.model.RemovingMultipleSubscribersResponse;
import io.swagger.client.model.UnsubscribingSubscribersFromAccountRequest;
import io.swagger.client.model.UnsubscribingSubscribersFromAccountResponse;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListRequest;
import io.swagger.client.model.UnsubscribingSubscribersFromMailingListResponse;
import io.swagger.client.model.UpdatingASubscriberRequest;
import io.swagger.client.model.UpdatingASubscriberResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SubscribersApi {
    private ApiClient apiClient;

    public SubscribersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscribersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addingMultipleSubscribersCall(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddingMultipleSubscribersRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/subscribe_many.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addingMultipleSubscribersValidateBeforeCall(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling addingMultipleSubscribers(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling addingMultipleSubscribers(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling addingMultipleSubscribers(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addingMultipleSubscribers(Async)");
        }
        Call call = this.addingMultipleSubscribersCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public AddingMultipleSubscribersResponse addingMultipleSubscribers(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body) throws ApiException {
        ApiResponse<AddingMultipleSubscribersResponse> resp = this.addingMultipleSubscribersWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<AddingMultipleSubscribersResponse> addingMultipleSubscribersWithHttpInfo(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body) throws ApiException {
        Call call = this.addingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<AddingMultipleSubscribersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addingMultipleSubscribersAsync(String format, String apikey, String mailingListID, AddingMultipleSubscribersRequest body, final ApiCallback<AddingMultipleSubscribersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddingMultipleSubscribersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call addingSubscribersCall(String format, String mailingListID, String apikey, AddingSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddingSubscribersRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/subscribe.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addingSubscribersValidateBeforeCall(String format, String mailingListID, String apikey, AddingSubscribersRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling addingSubscribers(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling addingSubscribers(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling addingSubscribers(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addingSubscribers(Async)");
        }
        Call call = this.addingSubscribersCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        return call;
    }

    public AddingSubscribersResponse addingSubscribers(String format, String mailingListID, String apikey, AddingSubscribersRequest body) throws ApiException {
        ApiResponse<AddingSubscribersResponse> resp = this.addingSubscribersWithHttpInfo(format, mailingListID, apikey, body);
        return resp.getData();
    }

    public ApiResponse<AddingSubscribersResponse> addingSubscribersWithHttpInfo(String format, String mailingListID, String apikey, AddingSubscribersRequest body) throws ApiException {
        Call call = this.addingSubscribersValidateBeforeCall(format, mailingListID, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<AddingSubscribersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addingSubscribersAsync(String format, String mailingListID, String apikey, AddingSubscribersRequest body, final ApiCallback<AddingSubscribersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addingSubscribersValidateBeforeCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddingSubscribersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSubscriberByEmailAddressCall(String format, String apikey, String mailingListID, String email, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscribers/{MailingListID}/view.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "Email", email));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSubscriberByEmailAddressValidateBeforeCall(String format, String apikey, String mailingListID, String email, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getSubscriberByEmailAddress(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getSubscriberByEmailAddress(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling getSubscriberByEmailAddress(Async)");
        }
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling getSubscriberByEmailAddress(Async)");
        }
        Call call = this.getSubscriberByEmailAddressCall(format, apikey, mailingListID, email, progressListener, progressRequestListener);
        return call;
    }

    public GetSubscriberByEmailAddressResponse getSubscriberByEmailAddress(String format, String apikey, String mailingListID, String email) throws ApiException {
        ApiResponse<GetSubscriberByEmailAddressResponse> resp = this.getSubscriberByEmailAddressWithHttpInfo(format, apikey, mailingListID, email);
        return resp.getData();
    }

    public ApiResponse<GetSubscriberByEmailAddressResponse> getSubscriberByEmailAddressWithHttpInfo(String format, String apikey, String mailingListID, String email) throws ApiException {
        Call call = this.getSubscriberByEmailAddressValidateBeforeCall(format, apikey, mailingListID, email, null, null);
        Type localVarReturnType = new TypeToken<GetSubscriberByEmailAddressResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSubscriberByEmailAddressAsync(String format, String apikey, String mailingListID, String email, final ApiCallback<GetSubscriberByEmailAddressResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSubscriberByEmailAddressValidateBeforeCall(format, apikey, mailingListID, email, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSubscriberByEmailAddressResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSubscriberByIdCall(String format, String apikey, String mailingListID, String subscriberID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscribers/{MailingListID}/find/{SubscriberID}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SubscriberID\\}", this.apiClient.escapeString(subscriberID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSubscriberByIdValidateBeforeCall(String format, String apikey, String mailingListID, String subscriberID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getSubscriberById(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getSubscriberById(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling getSubscriberById(Async)");
        }
        if (subscriberID == null) {
            throw new ApiException("Missing the required parameter 'subscriberID' when calling getSubscriberById(Async)");
        }
        Call call = this.getSubscriberByIdCall(format, apikey, mailingListID, subscriberID, progressListener, progressRequestListener);
        return call;
    }

    public GetSubscriberByIdResponse getSubscriberById(String format, String apikey, String mailingListID, String subscriberID) throws ApiException {
        ApiResponse<GetSubscriberByIdResponse> resp = this.getSubscriberByIdWithHttpInfo(format, apikey, mailingListID, subscriberID);
        return resp.getData();
    }

    public ApiResponse<GetSubscriberByIdResponse> getSubscriberByIdWithHttpInfo(String format, String apikey, String mailingListID, String subscriberID) throws ApiException {
        Call call = this.getSubscriberByIdValidateBeforeCall(format, apikey, mailingListID, subscriberID, null, null);
        Type localVarReturnType = new TypeToken<GetSubscriberByIdResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSubscriberByIdAsync(String format, String apikey, String mailingListID, String subscriberID, final ApiCallback<GetSubscriberByIdResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSubscriberByIdValidateBeforeCall(format, apikey, mailingListID, subscriberID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSubscriberByIdResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingSubscribersCall(String format, String mailingListID, String apikey, String status, Double page, Double pageSize, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/subscribers/{Status}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{Status\\}", this.apiClient.escapeString(status.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "Page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "PageSize", pageSize));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingSubscribersValidateBeforeCall(String format, String mailingListID, String apikey, String status, Double page, Double pageSize, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSubscribers(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSubscribers(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSubscribers(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling gettingSubscribers(Async)");
        }
        Call call = this.gettingSubscribersCall(format, mailingListID, apikey, status, page, pageSize, progressListener, progressRequestListener);
        return call;
    }

    public GettingSubscribersResponse gettingSubscribers(String format, String mailingListID, String apikey, String status, Double page, Double pageSize) throws ApiException {
        ApiResponse<GettingSubscribersResponse> resp = this.gettingSubscribersWithHttpInfo(format, mailingListID, apikey, status, page, pageSize);
        return resp.getData();
    }

    public ApiResponse<GettingSubscribersResponse> gettingSubscribersWithHttpInfo(String format, String mailingListID, String apikey, String status, Double page, Double pageSize) throws ApiException {
        Call call = this.gettingSubscribersValidateBeforeCall(format, mailingListID, apikey, status, page, pageSize, null, null);
        Type localVarReturnType = new TypeToken<GettingSubscribersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingSubscribersAsync(String format, String mailingListID, String apikey, String status, Double page, Double pageSize, final ApiCallback<GettingSubscribersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingSubscribersValidateBeforeCall(format, mailingListID, apikey, status, page, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSubscribersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removingASubscriberCall(String format, String apikey, String mailingListID, RemovingASubscriberRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemovingASubscriberRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/remove.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removingASubscriberValidateBeforeCall(String format, String apikey, String mailingListID, RemovingASubscriberRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling removingASubscriber(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling removingASubscriber(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling removingASubscriber(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling removingASubscriber(Async)");
        }
        Call call = this.removingASubscriberCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public RemovingASubscriberResponse removingASubscriber(String format, String apikey, String mailingListID, RemovingASubscriberRequest body) throws ApiException {
        ApiResponse<RemovingASubscriberResponse> resp = this.removingASubscriberWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<RemovingASubscriberResponse> removingASubscriberWithHttpInfo(String format, String apikey, String mailingListID, RemovingASubscriberRequest body) throws ApiException {
        Call call = this.removingASubscriberValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<RemovingASubscriberResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removingASubscriberAsync(String format, String apikey, String mailingListID, RemovingASubscriberRequest body, final ApiCallback<RemovingASubscriberResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removingASubscriberValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemovingASubscriberResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removingMultipleSubscribersCall(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemovingMultipleSubscribersRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/remove_many.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removingMultipleSubscribersValidateBeforeCall(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling removingMultipleSubscribers(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling removingMultipleSubscribers(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling removingMultipleSubscribers(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling removingMultipleSubscribers(Async)");
        }
        Call call = this.removingMultipleSubscribersCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public RemovingMultipleSubscribersResponse removingMultipleSubscribers(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body) throws ApiException {
        ApiResponse<RemovingMultipleSubscribersResponse> resp = this.removingMultipleSubscribersWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<RemovingMultipleSubscribersResponse> removingMultipleSubscribersWithHttpInfo(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body) throws ApiException {
        Call call = this.removingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<RemovingMultipleSubscribersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removingMultipleSubscribersAsync(String format, String apikey, String mailingListID, RemovingMultipleSubscribersRequest body, final ApiCallback<RemovingMultipleSubscribersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removingMultipleSubscribersValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemovingMultipleSubscribersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unsubscribingSubscribersFromAccountCall(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UnsubscribingSubscribersFromAccountRequest localVarPostBody = body;
        String localVarPath = "/subscribers/unsubscribe.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unsubscribingSubscribersFromAccountValidateBeforeCall(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unsubscribingSubscribersFromAccount(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unsubscribingSubscribersFromAccount(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unsubscribingSubscribersFromAccount(Async)");
        }
        Call call = this.unsubscribingSubscribersFromAccountCall(format, apikey, body, progressListener, progressRequestListener);
        return call;
    }

    public UnsubscribingSubscribersFromAccountResponse unsubscribingSubscribersFromAccount(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body) throws ApiException {
        ApiResponse<UnsubscribingSubscribersFromAccountResponse> resp = this.unsubscribingSubscribersFromAccountWithHttpInfo(format, apikey, body);
        return resp.getData();
    }

    public ApiResponse<UnsubscribingSubscribersFromAccountResponse> unsubscribingSubscribersFromAccountWithHttpInfo(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body) throws ApiException {
        Call call = this.unsubscribingSubscribersFromAccountValidateBeforeCall(format, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromAccountResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unsubscribingSubscribersFromAccountAsync(String format, String apikey, UnsubscribingSubscribersFromAccountRequest body, final ApiCallback<UnsubscribingSubscribersFromAccountResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unsubscribingSubscribersFromAccountValidateBeforeCall(format, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromAccountResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unsubscribingSubscribersFromMailingListCall(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UnsubscribingSubscribersFromMailingListRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/unsubscribe.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unsubscribingSubscribersFromMailingListValidateBeforeCall(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unsubscribingSubscribersFromMailingList(Async)");
        }
        Call call = this.unsubscribingSubscribersFromMailingListCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public UnsubscribingSubscribersFromMailingListResponse unsubscribingSubscribersFromMailingList(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body) throws ApiException {
        ApiResponse<UnsubscribingSubscribersFromMailingListResponse> resp = this.unsubscribingSubscribersFromMailingListWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<UnsubscribingSubscribersFromMailingListResponse> unsubscribingSubscribersFromMailingListWithHttpInfo(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body) throws ApiException {
        Call call = this.unsubscribingSubscribersFromMailingListValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unsubscribingSubscribersFromMailingListAsync(String format, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListRequest body, final ApiCallback<UnsubscribingSubscribersFromMailingListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unsubscribingSubscribersFromMailingListValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unsubscribingSubscribersFromMailingListAndASpecifiedCampaignCall(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/{CampaignID}/unsubscribe.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CampaignID\\}", this.apiClient.escapeString(campaignID.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unsubscribingSubscribersFromMailingListAndASpecifiedCampaignValidateBeforeCall(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(Async)");
        }
        Call call = this.unsubscribingSubscribersFromMailingListAndASpecifiedCampaignCall(format, campaignID, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse unsubscribingSubscribersFromMailingListAndASpecifiedCampaign(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body) throws ApiException {
        ApiResponse<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse> resp = this.unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo(format, campaignID, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse> unsubscribingSubscribersFromMailingListAndASpecifiedCampaignWithHttpInfo(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body) throws ApiException {
        Call call = this.unsubscribingSubscribersFromMailingListAndASpecifiedCampaignValidateBeforeCall(format, campaignID, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unsubscribingSubscribersFromMailingListAndASpecifiedCampaignAsync(String format, String campaignID, String apikey, String mailingListID, UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignRequest body, final ApiCallback<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unsubscribingSubscribersFromMailingListAndASpecifiedCampaignValidateBeforeCall(format, campaignID, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnsubscribingSubscribersFromMailingListAndASpecifiedCampaignResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatingASubscriberCall(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatingASubscriberRequest localVarPostBody = body;
        String localVarPath = "/subscribers/{MailingListID}/update/{SubscriberID}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString())).replaceAll("\\{SubscriberID\\}", this.apiClient.escapeString(subscriberID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatingASubscriberValidateBeforeCall(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingASubscriber(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingASubscriber(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingASubscriber(Async)");
        }
        if (subscriberID == null) {
            throw new ApiException("Missing the required parameter 'subscriberID' when calling updatingASubscriber(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingASubscriber(Async)");
        }
        Call call = this.updatingASubscriberCall(format, apikey, mailingListID, subscriberID, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdatingASubscriberResponse updatingASubscriber(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body) throws ApiException {
        ApiResponse<UpdatingASubscriberResponse> resp = this.updatingASubscriberWithHttpInfo(format, apikey, mailingListID, subscriberID, body);
        return resp.getData();
    }

    public ApiResponse<UpdatingASubscriberResponse> updatingASubscriberWithHttpInfo(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body) throws ApiException {
        Call call = this.updatingASubscriberValidateBeforeCall(format, apikey, mailingListID, subscriberID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingASubscriberResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatingASubscriberAsync(String format, String apikey, String mailingListID, String subscriberID, UpdatingASubscriberRequest body, final ApiCallback<UpdatingASubscriberResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatingASubscriberValidateBeforeCall(format, apikey, mailingListID, subscriberID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingASubscriberResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

