/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.spring;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.mcp.server.McpServer;
import org.springframework.ai.mcp.server.McpServerFeatures;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.util.ClassUtils;

public final class ToolHelper {
    private ToolHelper() {
    }

    public static List<McpServerFeatures.SyncToolRegistration> toSyncToolRegistration(List<FunctionCallback> functionCallbacks) {
        return functionCallbacks.stream().map(ToolHelper::toSyncToolRegistration).toList();
    }

    @Deprecated
    public static List<McpServer.ToolRegistration> toToolRegistration(List<FunctionCallback> functionCallbacks) {
        return functionCallbacks.stream().map(ToolHelper::toToolRegistration).toList();
    }

    public static List<McpServerFeatures.SyncToolRegistration> toSyncToolRegistration(FunctionCallback ... functionCallbacks) {
        return ToolHelper.toSyncToolRegistration(List.of(functionCallbacks));
    }

    @Deprecated
    public static List<McpServer.ToolRegistration> toToolRegistration(FunctionCallback ... functionCallbacks) {
        return ToolHelper.toToolRegistration(List.of(functionCallbacks));
    }

    public static McpServerFeatures.SyncToolRegistration toSyncToolRegistration(FunctionCallback functionCallback) {
        McpSchema.Tool tool = new McpSchema.Tool(functionCallback.getName(), functionCallback.getName(), functionCallback.getInputTypeSchema());
        return new McpServerFeatures.SyncToolRegistration(tool, request -> {
            try {
                String callResult = functionCallback.call(ModelOptionsUtils.toJsonString((Object)request));
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(callResult)), Boolean.valueOf(false));
            }
            catch (Exception e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(e.getMessage())), Boolean.valueOf(true));
            }
        });
    }

    @Deprecated
    public static McpServer.ToolRegistration toToolRegistration(FunctionCallback functionCallback) {
        McpSchema.Tool tool = new McpSchema.Tool(functionCallback.getName(), functionCallback.getName(), functionCallback.getInputTypeSchema());
        return new McpServer.ToolRegistration(tool, request -> {
            try {
                String callResult = functionCallback.call(ModelOptionsUtils.toJsonString((Object)request));
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(callResult)), Boolean.valueOf(false));
            }
            catch (Exception e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(e.getMessage())), Boolean.valueOf(true));
            }
        });
    }

    public static String generateJsonSchema(Map<String, Class<?>> namedClasses) {
        return ToolHelper.generateJsonSchema(namedClasses, new ObjectMapper());
    }

    public static String generateJsonSchema(Map<String, Class<?>> namedClasses, ObjectMapper mapper) {
        try {
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
            ObjectNode rootNode = mapper.createObjectNode();
            rootNode.put("$schema", "https://json-schema.org/draft/2020-12/schema");
            rootNode.put("type", "object");
            ObjectNode propertiesNode = rootNode.putObject("properties");
            for (Map.Entry<String, Class<?>> entry : namedClasses.entrySet()) {
                String className = entry.getKey();
                Class<?> clazz = entry.getValue();
                if (ClassUtils.isAssignable(clazz, ToolContext.class)) continue;
                JsonSchema schema = schemaGen.generateSchema(clazz);
                JsonNode schemaNode = mapper.valueToTree((Object)schema);
                propertiesNode.set(className, schemaNode);
            }
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

