/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class AnnotationUtils {
    private AnnotationUtils() throws InstantiationException {
        throw new InstantiationException("This class is not for instantiation");
    }

    static <T extends Annotation> String getValueOrNull(Class<T> annotationClass, Annotation ann) {
        if (!annotationClass.isInstance(ann)) {
            return null;
        }
        try {
            return (String)ann.annotationType().getMethod("value", new Class[0]).invoke((Object)ann, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't access element 'value' in  " + annotationClass + ". This is probably a bug in rescu.", e);
        }
    }

    static <A extends Annotation> A getFromMethodOrClass(Method method, Class<A> annotationClass) {
        A methodAnn = method.getAnnotation(annotationClass);
        if (methodAnn != null) {
            return methodAnn;
        }
        for (Class<?> cls = method.getDeclaringClass(); cls != null; cls = cls.getSuperclass()) {
            if (!cls.isAnnotationPresent(annotationClass)) continue;
            return cls.getAnnotation(annotationClass);
        }
        for (Class<?> intf : method.getDeclaringClass().getInterfaces()) {
            if (!intf.isAnnotationPresent(annotationClass)) continue;
            return intf.getAnnotation(annotationClass);
        }
        return null;
    }

    static Map<Class<? extends Annotation>, Annotation> getMethodAnnotationMap(Method method, Collection<Class<? extends Annotation>> annotationClasses) {
        Annotation[] methodAnnotations = method.getAnnotations();
        HashMap<Class<? extends Annotation>, Annotation> methodAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation methodAnnotation : methodAnnotations) {
            methodAnnotationMap.put(methodAnnotation.annotationType(), methodAnnotation);
        }
        methodAnnotationMap.keySet().retainAll(annotationClasses);
        return methodAnnotationMap;
    }
}

