/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner;

import com.github.mkolisnyk.cucumber.runner.ExtendedExecutionUnitRunner;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberScenario;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class ExtendedExamplesRunner
extends Suite {
    private int retryCount;
    private Runtime runtime;
    private final CucumberExamples cucumberExamples;
    private Description description;
    private JUnitReporter jUnitReporter;
    private static List<Runner> runners;
    private static List<CucumberScenario> exampleScenarios;

    protected ExtendedExamplesRunner(Runtime runtimeValue, CucumberExamples cucumberExamplesValue, JUnitReporter jUnitReporterValue, int retryCountValue) throws InitializationError {
        super(ExtendedExamplesRunner.class, ExtendedExamplesRunner.buildRunners(runtimeValue, cucumberExamplesValue, jUnitReporterValue));
        this.cucumberExamples = cucumberExamplesValue;
        this.jUnitReporter = jUnitReporterValue;
        this.runtime = runtimeValue;
        this.retryCount = retryCountValue;
    }

    private static List<Runner> buildRunners(Runtime runtime, CucumberExamples cucumberExamples, JUnitReporter jUnitReporter) {
        runners = new ArrayList<Runner>();
        exampleScenarios = cucumberExamples.createExampleScenarios();
        for (CucumberScenario scenario : exampleScenarios) {
            try {
                ExtendedExecutionUnitRunner exampleScenarioRunner = new ExtendedExecutionUnitRunner(runtime, scenario, jUnitReporter);
                runners.add((Runner)exampleScenarioRunner);
            }
            catch (InitializationError initializationError) {
                initializationError.printStackTrace();
            }
        }
        return runners;
    }

    public final Runtime getRuntime() {
        return this.runtime;
    }

    protected String getName() {
        return this.cucumberExamples.getExamples().getKeyword() + ": " + this.cucumberExamples.getExamples().getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberExamples.getExamples(), (Annotation[])new Annotation[0]);
            for (Runner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public void run(RunNotifier notifier) {
        this.jUnitReporter.examples(this.cucumberExamples.getExamples());
        super.run(notifier);
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        ExtendedExecutionUnitRunner featureElementRunner = (ExtendedExecutionUnitRunner)runner;
        for (int i = 0; i <= this.retryCount; ++i) {
            try {
                featureElementRunner = new ExtendedExecutionUnitRunner(this.runtime, ((ExtendedExecutionUnitRunner)runner).getCucumberScenario(), this.jUnitReporter);
                featureElementRunner.run(notifier);
                Assert.assertEquals((long)0L, (long)this.getRuntime().exitStatus());
                break;
            }
            catch (AssumptionViolatedException e) {
                System.out.println("Scenario AssumptionViolatedException...");
                continue;
            }
            catch (Throwable e) {
                System.out.println(((ExtendedExecutionUnitRunner)runner).getCucumberScenario().getGherkinModel().getId());
                System.out.println(e.getClass().getCanonicalName() + ":" + e.getMessage());
                System.out.println("Initiating retry...");
                this.getRuntime().getErrors().clear();
            }
        }
        System.out.println(((ExtendedExecutionUnitRunner)runner).getCucumberScenario().getGherkinModel().getId() + "Scenario completed..." + this.getRuntime().exitStatus());
    }
}

