/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.breakdown.valuators;

import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownStats;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.Matcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.valuators.Valuator;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import org.apache.commons.lang.StringUtils;

public class StepsValuator
implements Valuator {
    private boolean docstringMatches(String docstring, String expression) {
        if (StringUtils.isEmpty((String)docstring)) {
            return false;
        }
        return docstring.equals(expression) || docstring.matches(expression);
    }

    private boolean rowsMatch(String[][] rows, String expression) {
        if (rows == null) {
            return false;
        }
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < rows[i].length; ++j) {
                if (!rows[i][j].equals(expression) && !rows[i][j].matches(expression)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BreakdownStats valuate(CucumberScenarioResult[] results, String expression, Matcher[] matchers) {
        BreakdownStats stats = new BreakdownStats();
        for (CucumberScenarioResult result : results) {
            for (CucumberStepResult step : result.getSteps()) {
                if (!step.getName().equals(expression) && !step.getName().matches(expression) && !this.docstringMatches(step.getDocString(), expression) && !this.rowsMatch(step.getRows(), expression)) continue;
                String status = step.getResult().getStatus();
                if (status.equalsIgnoreCase("passed")) {
                    stats.addPassed();
                    continue;
                }
                if (status.equalsIgnoreCase("failed")) {
                    stats.addFailed();
                    continue;
                }
                stats.addSkipped();
            }
        }
        return stats;
    }
}

