/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import org.osmdroid.bonuspack.routing.RoadNode;

public class RoadLeg
implements Parcelable {
    public double mLength;
    public double mDuration;
    public int mStartNodeIndex;
    public int mEndNodeIndex;
    public static final Parcelable.Creator<RoadLeg> CREATOR = new Parcelable.Creator<RoadLeg>(){

        public RoadLeg createFromParcel(Parcel source) {
            return new RoadLeg(source);
        }

        public RoadLeg[] newArray(int size) {
            return new RoadLeg[size];
        }
    };

    public RoadLeg() {
        this.mDuration = 0.0;
        this.mLength = 0.0;
        this.mEndNodeIndex = 0;
        this.mStartNodeIndex = 0;
    }

    public RoadLeg(int startNodeIndex, int endNodeIndex, ArrayList<RoadNode> nodes) {
        this.mStartNodeIndex = startNodeIndex;
        this.mEndNodeIndex = endNodeIndex;
        this.mDuration = 0.0;
        this.mLength = 0.0;
        for (int i = startNodeIndex; i <= endNodeIndex; ++i) {
            RoadNode node = nodes.get(i);
            this.mLength += node.mLength;
            this.mDuration += node.mDuration;
        }
        Log.d((String)"BONUSPACK", (String)("Leg: " + startNodeIndex + "-" + endNodeIndex + ", length=" + this.mLength + "km, duration=" + this.mDuration + "s"));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.mLength);
        out.writeDouble(this.mDuration);
        out.writeInt(this.mStartNodeIndex);
        out.writeInt(this.mEndNodeIndex);
    }

    private RoadLeg(Parcel in) {
        this.mLength = in.readDouble();
        this.mDuration = in.readDouble();
        this.mStartNodeIndex = in.readInt();
        this.mEndNodeIndex = in.readInt();
    }
}

