/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import org.osmdroid.bonuspack.R;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.PointReducer;

public class Road
implements Parcelable {
    public int mStatus;
    public double mLength;
    public double mDuration;
    public ArrayList<RoadNode> mNodes;
    public ArrayList<RoadLeg> mLegs;
    public ArrayList<GeoPoint> mRouteHigh;
    private ArrayList<GeoPoint> mRouteLow;
    public BoundingBox mBoundingBox;
    public static final int STATUS_INVALID = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_TECHNICAL_ISSUE = 2;
    public static final Parcelable.Creator<Road> CREATOR = new Parcelable.Creator<Road>(){

        public Road createFromParcel(Parcel source) {
            return new Road(source);
        }

        public Road[] newArray(int size) {
            return new Road[size];
        }
    };

    private void init() {
        this.mStatus = -1;
        this.mLength = 0.0;
        this.mDuration = 0.0;
        this.mNodes = new ArrayList();
        this.mRouteHigh = new ArrayList();
        this.mRouteLow = null;
        this.mLegs = new ArrayList();
        this.mBoundingBox = null;
    }

    public Road() {
        this.init();
    }

    public Road(ArrayList<GeoPoint> waypoints) {
        int i;
        this.init();
        int n = waypoints.size();
        for (i = 0; i < n; ++i) {
            GeoPoint p = waypoints.get(i);
            this.mRouteHigh.add(p);
        }
        for (i = 0; i < n - 1; ++i) {
            RoadLeg leg = new RoadLeg();
            this.mLegs.add(leg);
        }
        this.mBoundingBox = BoundingBox.fromGeoPoints(this.mRouteHigh);
        this.mStatus = 2;
    }

    public ArrayList<GeoPoint> getRouteLow() {
        if (this.mRouteLow == null) {
            int n = this.mRouteHigh.size();
            this.mRouteLow = PointReducer.reduceWithTolerance(this.mRouteHigh, (double)1500.0);
            Log.d((String)"BONUSPACK", (String)("Road reduced from " + n + " to " + this.mRouteLow.size() + " points"));
        }
        return this.mRouteLow;
    }

    public void setRouteLow(ArrayList<GeoPoint> route) {
        this.mRouteLow = route;
    }

    public static String getLengthDurationText(Context context, double length, double duration) {
        String result = length >= 100.0 ? context.getString(R.string.osmbonuspack_format_distance_kilometers, new Object[]{(int)length}) + ", " : (length >= 1.0 ? context.getString(R.string.osmbonuspack_format_distance_kilometers, new Object[]{(double)Math.round(length * 10.0) / 10.0}) + ", " : context.getString(R.string.osmbonuspack_format_distance_meters, new Object[]{(int)(length * 1000.0)}) + ", ");
        int totalSeconds = (int)duration;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds / 60 - hours * 60;
        int seconds = totalSeconds % 60;
        if (hours != 0) {
            result = result + context.getString(R.string.osmbonuspack_format_hours, new Object[]{hours}) + " ";
        }
        if (minutes != 0) {
            result = result + context.getString(R.string.osmbonuspack_format_minutes, new Object[]{minutes}) + " ";
        }
        if (hours == 0 && minutes == 0) {
            result = result + context.getString(R.string.osmbonuspack_format_seconds, new Object[]{seconds});
        }
        return result;
    }

    public String getLengthDurationText(Context context, int leg) {
        double length = leg == -1 ? this.mLength : this.mLegs.get((int)leg).mLength;
        double duration = leg == -1 ? this.mDuration : this.mLegs.get((int)leg).mDuration;
        return Road.getLengthDurationText(context, length, duration);
    }

    protected double distanceLLSquared(GeoPoint p1, GeoPoint p2) {
        double deltaLat = p2.getLatitude() - p1.getLatitude();
        double deltaLon = p2.getLongitude() - p1.getLongitude();
        return deltaLat * deltaLat + deltaLon * deltaLon;
    }

    public void buildLegs(ArrayList<GeoPoint> waypoints) {
        this.mLegs = new ArrayList();
        int firstNodeIndex = 0;
        int w = waypoints.size();
        int n = this.mNodes.size();
        for (int i = 1; i < w - 1; ++i) {
            GeoPoint waypoint = waypoints.get(i);
            double distanceMin = -1.0;
            int nodeIndexMin = -1;
            for (int j = firstNodeIndex; j < n; ++j) {
                GeoPoint roadPoint = this.mNodes.get((int)j).mLocation;
                double dSquared = this.distanceLLSquared(roadPoint, waypoint);
                if (nodeIndexMin != -1 && !(dSquared < distanceMin)) continue;
                distanceMin = dSquared;
                nodeIndexMin = j;
            }
            RoadLeg leg = new RoadLeg(firstNodeIndex, nodeIndexMin, this.mNodes);
            this.mLegs.add(leg);
            firstNodeIndex = nodeIndexMin + 1;
        }
        RoadLeg lastLeg = new RoadLeg(firstNodeIndex, n - 1, this.mNodes);
        this.mLegs.add(lastLeg);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatus);
        out.writeDouble(this.mLength);
        out.writeDouble(this.mDuration);
        out.writeList(this.mNodes);
        out.writeList(this.mLegs);
        out.writeList(this.mRouteHigh);
        out.writeParcelable((Parcelable)this.mBoundingBox, 0);
    }

    private Road(Parcel in) {
        this.mStatus = in.readInt();
        this.mLength = in.readDouble();
        this.mDuration = in.readDouble();
        this.mNodes = in.readArrayList(RoadNode.class.getClassLoader());
        this.mLegs = in.readArrayList(RoadLeg.class.getClassLoader());
        this.mRouteHigh = in.readArrayList(GeoPoint.class.getClassLoader());
        this.mBoundingBox = (BoundingBox)in.readParcelable(BoundingBox.class.getClassLoader());
    }
}

