/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.zip.ZipFile;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.IconStyle;
import org.osmdroid.bonuspack.kml.LineStyle;
import org.osmdroid.bonuspack.kml.StyleSelector;

public class Style
extends StyleSelector
implements Parcelable {
    public ColorStyle mPolyStyle;
    public LineStyle mLineStyle;
    public IconStyle mIconStyle;
    public static final Parcelable.Creator<Style> CREATOR = new Parcelable.Creator<Style>(){

        public Style createFromParcel(Parcel source) {
            return new Style(source);
        }

        public Style[] newArray(int size) {
            return new Style[size];
        }
    };

    public Style() {
    }

    public Style(Bitmap icon, int lineColor, float lineWidth, int fillColor) {
        this();
        this.mIconStyle = new IconStyle();
        this.mIconStyle.mIcon = icon;
        this.mLineStyle = new LineStyle(lineColor, lineWidth);
        this.mPolyStyle = new ColorStyle(fillColor);
    }

    public void setIcon(String iconHref, File containerFile, ZipFile kmzContainer) {
        if (this.mIconStyle == null) {
            this.mIconStyle = new IconStyle();
        }
        this.mIconStyle.setIcon(iconHref, containerFile, kmzContainer);
    }

    public BitmapDrawable getFinalIcon(Context context) {
        if (this.mIconStyle != null) {
            return this.mIconStyle.getFinalIcon(context);
        }
        return null;
    }

    public Paint getOutlinePaint() {
        if (this.mLineStyle != null) {
            return this.mLineStyle.getOutlinePaint();
        }
        Paint outlinePaint = new Paint();
        outlinePaint.setStyle(Paint.Style.STROKE);
        return outlinePaint;
    }

    protected void writePolyStyle(Writer writer, ColorStyle colorStyle) {
        try {
            writer.write("<PolyStyle>\n");
            colorStyle.writeAsKML(writer);
            writer.write("</PolyStyle>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeAsKML(Writer writer, String styleId) {
        try {
            writer.write("<Style id='" + styleId + "'>\n");
            if (this.mLineStyle != null) {
                this.mLineStyle.writeAsKML(writer);
            }
            if (this.mPolyStyle != null) {
                this.writePolyStyle(writer, this.mPolyStyle);
            }
            if (this.mIconStyle != null) {
                this.mIconStyle.writeAsKML(writer);
            }
            writer.write("</Style>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.mLineStyle, flags);
        out.writeParcelable((Parcelable)this.mPolyStyle, flags);
        out.writeParcelable((Parcelable)this.mIconStyle, flags);
    }

    public Style(Parcel in) {
        this.mLineStyle = (LineStyle)in.readParcelable(LineStyle.class.getClassLoader());
        this.mPolyStyle = (ColorStyle)in.readParcelable(ColorStyle.class.getClassLoader());
        this.mIconStyle = (IconStyle)in.readParcelable(IconStyle.class.getClassLoader());
    }
}

