/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import org.osmdroid.bonuspack.kml.ColorStyle;

public class LineStyle
extends ColorStyle
implements Parcelable {
    public float mWidth;
    public static final Parcelable.Creator<LineStyle> CREATOR = new Parcelable.Creator<LineStyle>(){

        public LineStyle createFromParcel(Parcel source) {
            return new LineStyle(source);
        }

        public LineStyle[] newArray(int size) {
            return new LineStyle[size];
        }
    };

    public LineStyle() {
        this(0, 1.0f);
    }

    public LineStyle(int color, float width) {
        super(color);
        this.mWidth = width;
    }

    public Paint getOutlinePaint() {
        Paint outlinePaint = new Paint();
        outlinePaint.setColor(this.getFinalColor());
        outlinePaint.setStrokeWidth(this.mWidth);
        outlinePaint.setStyle(Paint.Style.STROKE);
        return outlinePaint;
    }

    @Override
    public void writeAsKML(Writer writer) {
        try {
            writer.write("<LineStyle>\n");
            super.writeAsKML(writer);
            writer.write("<width>" + this.mWidth + "</width>\n");
            writer.write("</LineStyle>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeFloat(this.mWidth);
    }

    public LineStyle(Parcel in) {
        super(in);
        this.mWidth = in.readFloat();
    }
}

