/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringEscapeUtils;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.bonuspack.overlays.GroundOverlay;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class KmlGroundOverlay
extends KmlFeature
implements Cloneable,
Parcelable {
    public String mIconHref;
    public Bitmap mIcon;
    public int mColor;
    public float mRotation;
    public ArrayList<GeoPoint> mCoordinates;
    public static final Parcelable.Creator<KmlGroundOverlay> CREATOR = new Parcelable.Creator<KmlGroundOverlay>(){

        public KmlGroundOverlay createFromParcel(Parcel source) {
            return new KmlGroundOverlay(source);
        }

        public KmlGroundOverlay[] newArray(int size) {
            return new KmlGroundOverlay[size];
        }
    };

    public KmlGroundOverlay() {
        this.mColor = -16777216;
    }

    public KmlGroundOverlay(GroundOverlay overlay) {
        this();
        this.mCoordinates = overlay.getAllBounds();
        this.mIcon = overlay.getImage();
        this.mRotation = -overlay.getBearing();
        this.mColor = 255 - Color.alpha((int)((int)(overlay.getTransparency() * 255.0f)));
        this.mVisibility = overlay.isEnabled();
    }

    @Override
    public BoundingBox getBoundingBox() {
        return BoundingBox.fromGeoPoints(this.mCoordinates);
    }

    public void setIcon(String href, File containerFile, ZipFile kmzContainer) {
        this.mIconHref = href;
        if (this.mIconHref.startsWith("http://") || this.mIconHref.startsWith("https://")) {
            this.mIcon = BonusPackHelper.loadBitmap(this.mIconHref);
        } else if (kmzContainer == null) {
            if (containerFile != null) {
                String actualFullPath = containerFile.getParent() + '/' + this.mIconHref;
                this.mIcon = BitmapFactory.decodeFile((String)actualFullPath);
            } else {
                this.mIcon = null;
            }
        } else {
            try {
                ZipEntry fileEntry = kmzContainer.getEntry(href);
                InputStream stream = kmzContainer.getInputStream(fileEntry);
                this.mIcon = BitmapFactory.decodeStream((InputStream)stream);
            }
            catch (Exception e) {
                this.mIcon = null;
            }
        }
    }

    public void setLatLonBox(double north, double south, double east, double west) {
        this.mCoordinates = new ArrayList(2);
        this.mCoordinates.add(new GeoPoint(north, west));
        this.mCoordinates.add(new GeoPoint(south, east));
    }

    public void setLatLonQuad(ArrayList<GeoPoint> coords) {
        this.mCoordinates = new ArrayList(coords.size());
        for (GeoPoint g : coords) {
            this.mCoordinates.add(g.clone());
        }
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlDocument kmlDocument) {
        GroundOverlay overlay = new GroundOverlay();
        if (this.mCoordinates.size() == 2) {
            GeoPoint pNW = this.mCoordinates.get(0);
            GeoPoint pSE = this.mCoordinates.get(1);
            overlay.setPositionFromBounds(pNW, pSE);
        } else if (this.mCoordinates.size() == 4) {
            overlay.setPositionFromBounds(this.mCoordinates.get(3), this.mCoordinates.get(2), this.mCoordinates.get(1), this.mCoordinates.get(0));
        }
        if (this.mIcon != null) {
            overlay.setImage(this.mIcon);
            float transparency = 1.0f - (float)Color.alpha((int)this.mColor) / 255.0f;
            overlay.setTransparency(transparency);
        } else {
            Bitmap bitmap = Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(this.mColor);
            overlay.setImage(bitmap);
        }
        overlay.setBearing(-this.mRotation);
        if (styler == null) {
            overlay.setEnabled(this.mVisibility);
        } else {
            styler.onFeature(overlay, this);
        }
        return overlay;
    }

    @Override
    public void writeKMLSpecifics(Writer writer) {
        try {
            writer.write("<color>" + ColorStyle.colorAsKMLString(this.mColor) + "</color>\n");
            writer.write("<Icon><href>" + StringEscapeUtils.escapeXml10((String)this.mIconHref) + "</href></Icon>\n");
            if (this.mCoordinates.size() == 2) {
                writer.write("<LatLonBox>");
                GeoPoint pNW = this.mCoordinates.get(0);
                GeoPoint pSE = this.mCoordinates.get(1);
                writer.write("<north>" + pNW.getLatitude() + "</north>");
                writer.write("<south>" + pSE.getLatitude() + "</south>");
                writer.write("<east>" + pSE.getLongitude() + "</east>");
                writer.write("<west>" + pNW.getLongitude() + "</west>");
                writer.write("<rotation>" + this.mRotation + "</rotation>");
                writer.write("</LatLonBox>\n");
            } else {
                writer.write("<gx:LatLonQuad>");
                KmlGeometry.writeKMLCoordinates(writer, this.mCoordinates);
                writer.write("</gx:LatLonQuad>\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject asGeoJSON(boolean isRoot) {
        return null;
    }

    @Override
    public KmlGroundOverlay clone() {
        KmlGroundOverlay kmlGroundOverlay = (KmlGroundOverlay)super.clone();
        kmlGroundOverlay.mCoordinates = KmlGeometry.cloneArrayOfGeoPoint(this.mCoordinates);
        return kmlGroundOverlay;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.mIconHref);
        out.writeParcelable((Parcelable)this.mIcon, flags);
        out.writeInt(this.mColor);
        out.writeFloat(this.mRotation);
        out.writeList(this.mCoordinates);
    }

    public KmlGroundOverlay(Parcel in) {
        super(in);
        this.mIconHref = in.readString();
        this.mIcon = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.mColor = in.readInt();
        this.mRotation = in.readFloat();
        this.mCoordinates = in.readArrayList(GeoPoint.class.getClassLoader());
    }
}

