/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlMultiGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public abstract class KmlGeometry
implements Cloneable,
Parcelable {
    public String mId;
    public ArrayList<GeoPoint> mCoordinates;

    public abstract void saveAsKML(Writer var1);

    public abstract JsonObject asGeoJSON();

    public abstract Overlay buildOverlay(MapView var1, Style var2, KmlFeature.Styler var3, KmlPlacemark var4, KmlDocument var5);

    public abstract BoundingBox getBoundingBox();

    public KmlGeometry() {
    }

    public static boolean writeKMLCoordinates(Writer writer, ArrayList<GeoPoint> coordinates) {
        try {
            writer.write("<coordinates>");
            for (GeoPoint coord : coordinates) {
                writer.write(coord.toInvertedDoubleString());
                writer.write(32);
            }
            writer.write("</coordinates>\n");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static JsonArray geoJSONPosition(GeoPoint position) {
        JsonArray json = new JsonArray();
        json.add((JsonElement)new JsonPrimitive((Number)position.getLongitude()));
        json.add((JsonElement)new JsonPrimitive((Number)position.getLatitude()));
        return json;
    }

    public static JsonArray geoJSONCoordinates(ArrayList<GeoPoint> coordinates) {
        JsonArray json = new JsonArray();
        for (GeoPoint position : coordinates) {
            json.add((JsonElement)KmlGeometry.geoJSONPosition(position));
        }
        return json;
    }

    public static ArrayList<GeoPoint> cloneArrayOfGeoPoint(ArrayList<GeoPoint> coords) {
        ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(coords.size());
        for (GeoPoint p : coords) {
            result.add(p.clone());
        }
        return result;
    }

    public static GeoPoint parseGeoJSONPosition(JsonArray json) {
        double alt = json.size() >= 3 ? json.get(2).getAsDouble() : 0.0;
        return new GeoPoint(json.get(1).getAsDouble(), json.get(0).getAsDouble(), alt);
    }

    public static ArrayList<GeoPoint> parseGeoJSONPositions(JsonArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<GeoPoint> coordinates = new ArrayList<GeoPoint>(json.size());
        for (int i = 0; i < json.size(); ++i) {
            JsonArray position = json.get(i).getAsJsonArray();
            GeoPoint p = KmlGeometry.parseGeoJSONPosition(position);
            if (p == null) continue;
            coordinates.add(p);
        }
        return coordinates;
    }

    public static KmlGeometry parseGeoJSON(JsonObject json) {
        if (json == null) {
            return null;
        }
        String type = json.get("type").getAsString();
        if ("Point".equals(type)) {
            return new KmlPoint(json);
        }
        if ("LineString".equals(type)) {
            return new KmlLineString(json);
        }
        if ("Polygon".equals(type)) {
            return new KmlPolygon(json);
        }
        if ("GeometryCollection".equals(type) || "MultiPoint".equals(type) || "MultiLineString".equals(type) || "MultiPolygon".equals(type)) {
            return new KmlMultiGeometry(json);
        }
        return null;
    }

    public KmlGeometry clone() {
        KmlGeometry kmlGeometry;
        try {
            kmlGeometry = (KmlGeometry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (this.mCoordinates != null) {
            kmlGeometry.mCoordinates = KmlGeometry.cloneArrayOfGeoPoint(this.mCoordinates);
        }
        return kmlGeometry;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mId);
        out.writeList(this.mCoordinates);
    }

    public KmlGeometry(Parcel in) {
        this.mId = in.readString();
        this.mCoordinates = in.readArrayList(GeoPoint.class.getClassLoader());
    }
}

