/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.HotSpot;
import org.osmdroid.bonuspack.kml.IconStyle;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlFolder;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlGroundOverlay;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlMultiGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.KmlTrack;
import org.osmdroid.bonuspack.kml.LineStyle;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.bonuspack.kml.StyleMap;
import org.osmdroid.bonuspack.kml.StyleSelector;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KmlDocument
implements Parcelable {
    public KmlFolder mKmlRoot;
    protected HashMap<String, StyleSelector> mStyles;
    protected int mMaxStyleId;
    protected File mLocalFile;
    protected static HashMap<String, KmlKeywords> KEYWORDS_DICTIONARY = new HashMap();
    public static final Parcelable.Creator<KmlDocument> CREATOR;

    public KmlDocument() {
        this.mStyles = new HashMap();
        this.mMaxStyleId = 0;
        this.mKmlRoot = new KmlFolder();
        this.mLocalFile = null;
    }

    public HashMap<String, StyleSelector> getStyles() {
        return this.mStyles;
    }

    public String[] getStylesList() {
        Set<String> set = this.mStyles.keySet();
        String[] array = new String[]{};
        return set.toArray(array);
    }

    public Style getStyle(String styleId) {
        StyleSelector s = this.mStyles.get(styleId);
        if (s == null) {
            return null;
        }
        if (s instanceof StyleMap) {
            return ((StyleMap)s).getNormalStyle(this);
        }
        return (Style)s;
    }

    public void putStyle(String styleId, StyleSelector styleSelector) {
        try {
            int id = Integer.parseInt(styleId);
            this.mMaxStyleId = Math.max(this.mMaxStyleId, id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mStyles.put(styleId, styleSelector);
    }

    public String addStyle(StyleSelector styleSelector) {
        ++this.mMaxStyleId;
        String newId = "" + this.mMaxStyleId;
        this.putStyle(newId, styleSelector);
        return newId;
    }

    public File getLocalFile() {
        return this.mLocalFile;
    }

    protected static GeoPoint parseKmlCoord(String input) {
        int end1 = input.indexOf(44);
        int end2 = input.indexOf(44, end1 + 1);
        try {
            if (end2 == -1) {
                double lon = Double.parseDouble(input.substring(0, end1));
                double lat = Double.parseDouble(input.substring(end1 + 1, input.length()));
                return new GeoPoint(lat, lon);
            }
            double lon = Double.parseDouble(input.substring(0, end1));
            double lat = Double.parseDouble(input.substring(end1 + 1, end2));
            double alt = Double.parseDouble(input.substring(end2 + 1, input.length()));
            return new GeoPoint(lat, lon, alt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected static ArrayList<GeoPoint> parseKmlCoordinates(String input) {
        LinkedList<GeoPoint> tmpCoords = new LinkedList<GeoPoint>();
        int tupleStart = 0;
        int length = input.length();
        boolean startReadingTuple = false;
        for (int i = 0; i < length; ++i) {
            GeoPoint p;
            String tuple;
            char c = input.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') {
                if (!startReadingTuple) continue;
                tuple = input.substring(tupleStart, i);
                p = KmlDocument.parseKmlCoord(tuple);
                if (p != null) {
                    tmpCoords.add(p);
                }
                startReadingTuple = false;
                continue;
            }
            if (!startReadingTuple) {
                startReadingTuple = true;
                tupleStart = i;
            }
            if (i != length - 1 || (p = KmlDocument.parseKmlCoord(tuple = input.substring(tupleStart, i + 1))) == null) continue;
            tmpCoords.add(p);
        }
        ArrayList<GeoPoint> coordinates = new ArrayList<GeoPoint>(tmpCoords.size());
        coordinates.addAll(tmpCoords);
        return coordinates;
    }

    public boolean parseKMLUrl(String url) {
        Log.d((String)"BONUSPACK", (String)("KmlProvider.parseKMLUrl:" + url));
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        InputStream stream = connection.getStream();
        boolean ok = stream == null ? false : this.parseKMLStream(stream, null);
        connection.close();
        return ok;
    }

    public File getDefaultPathForAndroid(Context context, String fileName) {
        if (Build.VERSION.SDK_INT >= 19) {
            return new File(context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS), fileName);
        }
        try {
            File path = new File(Environment.getExternalStorageDirectory(), "kml");
            path.mkdir();
            return new File(path.getAbsolutePath(), fileName);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean parseKMLFile(File file) {
        boolean ok;
        this.mLocalFile = file;
        Log.d((String)"BONUSPACK", (String)("KmlProvider.parseKMLFile:" + this.mLocalFile.getAbsolutePath()));
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.mLocalFile));
            ok = this.parseKMLStream(stream, null);
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ok = false;
        }
        Log.d((String)"BONUSPACK", (String)"KmlProvider.parseFile - end");
        return ok;
    }

    public boolean parseKMZFile(File file) {
        this.mLocalFile = file;
        Log.d((String)"BONUSPACK", (String)("KmlProvider.parseKMZFile:" + this.mLocalFile.getAbsolutePath()));
        try {
            boolean result;
            ZipFile kmzFile = new ZipFile(this.mLocalFile);
            String rootFileName = null;
            Enumeration<? extends ZipEntry> list = kmzFile.entries();
            while (list.hasMoreElements() && rootFileName == null) {
                ZipEntry ze = list.nextElement();
                String name = ze.getName();
                if (!name.endsWith(".kml") || name.contains("/")) continue;
                rootFileName = name;
            }
            if (rootFileName != null) {
                ZipEntry rootEntry = kmzFile.getEntry(rootFileName);
                InputStream stream = kmzFile.getInputStream(rootEntry);
                Log.d((String)"BONUSPACK", (String)("KML root:" + rootFileName));
                result = this.parseKMLStream(stream, kmzFile);
            } else {
                Log.d((String)"BONUSPACK", (String)"No .kml entry found.");
                result = false;
            }
            kmzFile.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean parseKMLStream(InputStream stream, ZipFile kmzContainer) {
        boolean ok;
        KmlSaxHandler handler = new KmlSaxHandler(this.mLocalFile, kmzContainer);
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(stream, (DefaultHandler)handler);
            this.mKmlRoot = handler.mKmlRoot;
            ok = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            ok = false;
        }
        return ok;
    }

    public boolean saveAsKML(Writer writer) {
        try {
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            writer.write("<kml xmlns='http://www.opengis.net/kml/2.2' xmlns:gx='http://www.google.com/kml/ext/2.2'>\n");
            boolean result = true;
            if (this.mKmlRoot != null) {
                result = this.mKmlRoot.writeAsKML(writer, true, this);
            }
            writer.write("</kml>\n");
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void writeKMLStyles(Writer writer) {
        for (Map.Entry<String, StyleSelector> entry : this.mStyles.entrySet()) {
            String styleId = entry.getKey();
            StyleSelector styleSelector = entry.getValue();
            styleSelector.writeAsKML(writer, styleId);
        }
    }

    public boolean saveAsKML(File file) {
        try {
            Log.d((String)"BONUSPACK", (String)("Saving " + file.getAbsolutePath()));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            BufferedWriter writer = new BufferedWriter(out, 8192);
            boolean result = this.saveAsKML(writer);
            writer.close();
            Log.d((String)"BONUSPACK", (String)"Saved.");
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveAsGeoJSON(Writer writer) {
        JsonObject json = this.mKmlRoot.asGeoJSON(true);
        if (json == null) {
            return false;
        }
        try {
            Gson gson = new GsonBuilder().create();
            JsonWriter jsonWriter = new JsonWriter(writer);
            gson.toJson((JsonElement)json, jsonWriter);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveAsGeoJSON(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(fw, 8192);
            boolean result = this.saveAsGeoJSON(writer);
            writer.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean parseGeoJSON(JsonObject json) {
        KmlFeature feature = KmlFeature.parseGeoJSON(json);
        if (feature instanceof KmlFolder) {
            this.mKmlRoot = (KmlFolder)feature;
        } else {
            this.mKmlRoot = new KmlFolder();
            this.mKmlRoot.add(feature);
        }
        return true;
    }

    public boolean parseGeoJSON(String jsonString) {
        try {
            JsonElement json = JsonParser.parseString((String)jsonString);
            return this.parseGeoJSON(json.getAsJsonObject());
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean parseGeoJSONStream(InputStream stream) {
        JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream));
        return this.parseGeoJSON(json.getAsJsonObject());
    }

    public boolean parseGeoJSON(File file) {
        this.mLocalFile = file;
        try {
            FileInputStream input = new FileInputStream(this.mLocalFile);
            boolean ok = this.parseGeoJSONStream(input);
            input.close();
            return ok;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.mKmlRoot, flags);
        out.writeInt(this.mStyles.size());
        for (String key : this.mStyles.keySet()) {
            out.writeString(key);
            out.writeParcelable((Parcelable)this.mStyles.get(key), flags);
        }
        out.writeInt(this.mMaxStyleId);
        if (this.mLocalFile != null) {
            out.writeString(this.mLocalFile.getAbsolutePath());
        } else {
            out.writeString("");
        }
    }

    public KmlDocument(Parcel in) {
        this.mKmlRoot = (KmlFolder)in.readParcelable(KmlFeature.class.getClassLoader());
        int size = in.readInt();
        this.mStyles = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            Style value = (Style)in.readParcelable(Style.class.getClassLoader());
            this.mStyles.put(key, value);
        }
        this.mMaxStyleId = in.readInt();
        String filePath = in.readString();
        this.mLocalFile = filePath.equals("") ? null : new File(filePath);
    }

    static {
        KEYWORDS_DICTIONARY.put("Document", KmlKeywords.Document);
        KEYWORDS_DICTIONARY.put("Folder", KmlKeywords.Folder);
        KEYWORDS_DICTIONARY.put("NetworkLink", KmlKeywords.NetworkLink);
        KEYWORDS_DICTIONARY.put("GroundOverlay", KmlKeywords.GroundOverlay);
        KEYWORDS_DICTIONARY.put("Placemark", KmlKeywords.Placemark);
        KEYWORDS_DICTIONARY.put("Point", KmlKeywords.Point);
        KEYWORDS_DICTIONARY.put("LineString", KmlKeywords.LineString);
        KEYWORDS_DICTIONARY.put("gx:Track", KmlKeywords.gx_Track);
        KEYWORDS_DICTIONARY.put("Polygon", KmlKeywords.Polygon);
        KEYWORDS_DICTIONARY.put("innerBoundaryIs", KmlKeywords.innerBoundaryIs);
        KEYWORDS_DICTIONARY.put("MultiGeometry", KmlKeywords.MultiGeometry);
        KEYWORDS_DICTIONARY.put("Style", KmlKeywords.Style);
        KEYWORDS_DICTIONARY.put("StyleMap", KmlKeywords.StyleMap);
        KEYWORDS_DICTIONARY.put("LineStyle", KmlKeywords.LineStyle);
        KEYWORDS_DICTIONARY.put("PolyStyle", KmlKeywords.PolyStyle);
        KEYWORDS_DICTIONARY.put("IconStyle", KmlKeywords.IconStyle);
        KEYWORDS_DICTIONARY.put("hotSpot", KmlKeywords.hotSpot);
        KEYWORDS_DICTIONARY.put("Data", KmlKeywords.Data);
        KEYWORDS_DICTIONARY.put("SimpleData", KmlKeywords.SimpleData);
        KEYWORDS_DICTIONARY.put("id", KmlKeywords.id);
        KEYWORDS_DICTIONARY.put("name", KmlKeywords.name);
        KEYWORDS_DICTIONARY.put("description", KmlKeywords.description);
        KEYWORDS_DICTIONARY.put("visibility", KmlKeywords.visibility);
        KEYWORDS_DICTIONARY.put("open", KmlKeywords.open);
        KEYWORDS_DICTIONARY.put("coordinates", KmlKeywords.coordinates);
        KEYWORDS_DICTIONARY.put("gx:coord", KmlKeywords.gx_coord);
        KEYWORDS_DICTIONARY.put("when", KmlKeywords.when);
        KEYWORDS_DICTIONARY.put("styleUrl", KmlKeywords.styleUrl);
        KEYWORDS_DICTIONARY.put("key", KmlKeywords.key);
        KEYWORDS_DICTIONARY.put("color", KmlKeywords.color);
        KEYWORDS_DICTIONARY.put("colorMode", KmlKeywords.colorMode);
        KEYWORDS_DICTIONARY.put("width", KmlKeywords.width);
        KEYWORDS_DICTIONARY.put("scale", KmlKeywords.scale);
        KEYWORDS_DICTIONARY.put("heading", KmlKeywords.heading);
        KEYWORDS_DICTIONARY.put("href", KmlKeywords.href);
        KEYWORDS_DICTIONARY.put("north", KmlKeywords.north);
        KEYWORDS_DICTIONARY.put("south", KmlKeywords.south);
        KEYWORDS_DICTIONARY.put("east", KmlKeywords.east);
        KEYWORDS_DICTIONARY.put("west", KmlKeywords.west);
        KEYWORDS_DICTIONARY.put("rotation", KmlKeywords.rotation);
        KEYWORDS_DICTIONARY.put("LatLonBox", KmlKeywords.LatLonBox);
        KEYWORDS_DICTIONARY.put("value", KmlKeywords.value);
        CREATOR = new Parcelable.Creator<KmlDocument>(){

            public KmlDocument createFromParcel(Parcel source) {
                return new KmlDocument(source);
            }

            public KmlDocument[] newArray(int size) {
                return new KmlDocument[size];
            }
        };
    }

    protected class KmlSaxHandler
    extends DefaultHandler {
        private StringBuilder mStringBuilder = new StringBuilder(1024);
        private KmlFeature mKmlCurrentFeature;
        private KmlGroundOverlay mKmlCurrentGroundOverlay;
        private ArrayList<KmlFeature> mKmlFeatureStack;
        private KmlGeometry mKmlCurrentGeometry;
        private ArrayList<KmlGeometry> mKmlGeometryStack;
        public KmlFolder mKmlRoot;
        Style mCurrentStyle;
        String mCurrentStyleId;
        StyleMap mCurrentStyleMap;
        String mCurrentStyleKey;
        ColorStyle mColorStyle;
        String mDataName;
        boolean mIsNetworkLink;
        boolean mIsInnerBoundary;
        File mFile;
        ZipFile mKMZFile;
        double mNorth;
        double mEast;
        double mSouth;
        double mWest;

        public KmlSaxHandler(File file, ZipFile kmzContainer) {
            this.mFile = file;
            this.mKMZFile = kmzContainer;
            this.mKmlRoot = new KmlFolder();
            this.mKmlFeatureStack = new ArrayList();
            this.mKmlFeatureStack.add(this.mKmlRoot);
            this.mKmlGeometryStack = new ArrayList();
            this.mIsNetworkLink = false;
            this.mIsInnerBoundary = false;
        }

        protected void loadNetworkLink(String href, ZipFile kmzContainer) {
            boolean ok;
            KmlDocument subDocument = new KmlDocument();
            if (href.startsWith("http://") || href.startsWith("https://")) {
                ok = subDocument.parseKMLUrl(href);
            } else if (kmzContainer == null) {
                File subFile = new File(this.mFile.getParent() + '/' + href);
                ok = subDocument.parseKMLFile(subFile);
            } else {
                try {
                    ZipEntry fileEntry = kmzContainer.getEntry(href);
                    InputStream stream = kmzContainer.getInputStream(fileEntry);
                    Log.d((String)"BONUSPACK", (String)("Load NetworkLink:" + href));
                    ok = subDocument.parseKMLStream(stream, kmzContainer);
                }
                catch (Exception e) {
                    ok = false;
                }
            }
            if (ok) {
                ((KmlFolder)this.mKmlCurrentFeature).add(subDocument.mKmlRoot);
                KmlDocument.this.mStyles.putAll(subDocument.mStyles);
            } else {
                Log.e((String)"BONUSPACK", (String)("Error reading NetworkLink:" + href));
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            KmlKeywords element = KEYWORDS_DICTIONARY.get(name);
            if (element != null) {
                switch (element) {
                    case Document: {
                        this.mKmlCurrentFeature = this.mKmlRoot;
                        this.mKmlCurrentFeature.mId = attributes.getValue("id");
                        break;
                    }
                    case Folder: {
                        this.mKmlCurrentFeature = new KmlFolder();
                        this.mKmlCurrentFeature.mId = attributes.getValue("id");
                        this.mKmlFeatureStack.add(this.mKmlCurrentFeature);
                        break;
                    }
                    case NetworkLink: {
                        this.mKmlCurrentFeature = new KmlFolder();
                        this.mKmlCurrentFeature.mId = attributes.getValue("id");
                        this.mKmlFeatureStack.add(this.mKmlCurrentFeature);
                        this.mIsNetworkLink = true;
                        break;
                    }
                    case GroundOverlay: {
                        this.mKmlCurrentGroundOverlay = new KmlGroundOverlay();
                        this.mKmlCurrentFeature = this.mKmlCurrentGroundOverlay;
                        this.mKmlCurrentFeature.mId = attributes.getValue("id");
                        this.mKmlFeatureStack.add(this.mKmlCurrentFeature);
                        break;
                    }
                    case Placemark: {
                        this.mKmlCurrentFeature = new KmlPlacemark();
                        this.mKmlCurrentFeature.mId = attributes.getValue("id");
                        this.mKmlFeatureStack.add(this.mKmlCurrentFeature);
                        break;
                    }
                    case Point: {
                        this.mKmlCurrentGeometry = new KmlPoint();
                        this.mKmlGeometryStack.add(this.mKmlCurrentGeometry);
                        break;
                    }
                    case LineString: {
                        this.mKmlCurrentGeometry = new KmlLineString();
                        this.mKmlGeometryStack.add(this.mKmlCurrentGeometry);
                        break;
                    }
                    case gx_Track: {
                        this.mKmlCurrentGeometry = new KmlTrack();
                        this.mKmlGeometryStack.add(this.mKmlCurrentGeometry);
                        break;
                    }
                    case Polygon: {
                        this.mKmlCurrentGeometry = new KmlPolygon();
                        this.mKmlGeometryStack.add(this.mKmlCurrentGeometry);
                        break;
                    }
                    case innerBoundaryIs: {
                        this.mIsInnerBoundary = true;
                        break;
                    }
                    case MultiGeometry: {
                        this.mKmlCurrentGeometry = new KmlMultiGeometry();
                        this.mKmlGeometryStack.add(this.mKmlCurrentGeometry);
                        break;
                    }
                    case Style: {
                        this.mCurrentStyle = new Style();
                        this.mCurrentStyleId = attributes.getValue("id");
                        break;
                    }
                    case StyleMap: {
                        this.mCurrentStyleMap = new StyleMap();
                        this.mCurrentStyleId = attributes.getValue("id");
                        break;
                    }
                    case LineStyle: {
                        this.mCurrentStyle.mLineStyle = new LineStyle();
                        this.mColorStyle = this.mCurrentStyle.mLineStyle;
                        break;
                    }
                    case PolyStyle: {
                        this.mColorStyle = this.mCurrentStyle.mPolyStyle = new ColorStyle();
                        break;
                    }
                    case IconStyle: {
                        this.mCurrentStyle.mIconStyle = new IconStyle();
                        this.mColorStyle = this.mCurrentStyle.mIconStyle;
                        break;
                    }
                    case hotSpot: {
                        if (this.mCurrentStyle == null || this.mColorStyle == null || !(this.mColorStyle instanceof IconStyle)) break;
                        this.mCurrentStyle.mIconStyle.mHotSpot = new HotSpot(Float.parseFloat(attributes.getValue("x")), Float.parseFloat(attributes.getValue("y")), attributes.getValue("xunits"), attributes.getValue("yunits"));
                        break;
                    }
                    case Data: 
                    case SimpleData: {
                        this.mDataName = attributes.getValue("name");
                        break;
                    }
                }
            }
            this.mStringBuilder.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mStringBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            KmlKeywords element = KEYWORDS_DICTIONARY.get(name);
            if (element == null) {
                return;
            }
            switch (element) {
                case Document: {
                    break;
                }
                case Folder: 
                case NetworkLink: 
                case GroundOverlay: 
                case Placemark: {
                    KmlFolder parent = (KmlFolder)this.mKmlFeatureStack.get(this.mKmlFeatureStack.size() - 2);
                    parent.add(this.mKmlCurrentFeature);
                    this.mKmlFeatureStack.remove(this.mKmlFeatureStack.size() - 1);
                    this.mKmlCurrentFeature = this.mKmlFeatureStack.get(this.mKmlFeatureStack.size() - 1);
                    if (element == KmlKeywords.NetworkLink) {
                        this.mIsNetworkLink = false;
                        break;
                    }
                    if (element != KmlKeywords.GroundOverlay) break;
                    this.mKmlCurrentGroundOverlay = null;
                    break;
                }
                case innerBoundaryIs: {
                    this.mIsInnerBoundary = false;
                    break;
                }
                case Point: 
                case LineString: 
                case gx_Track: 
                case Polygon: 
                case MultiGeometry: {
                    if (this.mKmlGeometryStack.size() == 1) {
                        ((KmlPlacemark)this.mKmlCurrentFeature).mGeometry = this.mKmlCurrentGeometry;
                        this.mKmlGeometryStack.remove(this.mKmlGeometryStack.size() - 1);
                        this.mKmlCurrentGeometry = null;
                        break;
                    }
                    KmlMultiGeometry parent = (KmlMultiGeometry)this.mKmlGeometryStack.get(this.mKmlGeometryStack.size() - 2);
                    parent.addItem(this.mKmlCurrentGeometry);
                    this.mKmlGeometryStack.remove(this.mKmlGeometryStack.size() - 1);
                    this.mKmlCurrentGeometry = this.mKmlGeometryStack.get(this.mKmlGeometryStack.size() - 1);
                    break;
                }
                case name: {
                    this.mKmlCurrentFeature.mName = this.mStringBuilder.toString();
                    break;
                }
                case id: {
                    this.mKmlCurrentFeature.mId = this.mStringBuilder.toString();
                    break;
                }
                case description: {
                    this.mKmlCurrentFeature.mDescription = this.mStringBuilder.toString();
                    break;
                }
                case visibility: {
                    this.mKmlCurrentFeature.mVisibility = "1".equals(this.mStringBuilder.toString());
                    break;
                }
                case open: {
                    this.mKmlCurrentFeature.mOpen = "1".equals(this.mStringBuilder.toString());
                    break;
                }
                case coordinates: {
                    if (this.mKmlCurrentFeature instanceof KmlPlacemark) {
                        if (!this.mIsInnerBoundary) {
                            this.mKmlCurrentGeometry.mCoordinates = KmlDocument.parseKmlCoordinates(this.mStringBuilder.toString());
                            break;
                        }
                        KmlPolygon polygon = (KmlPolygon)this.mKmlCurrentGeometry;
                        if (polygon.mHoles == null) {
                            polygon.mHoles = new ArrayList();
                        }
                        ArrayList<GeoPoint> hole = KmlDocument.parseKmlCoordinates(this.mStringBuilder.toString());
                        polygon.mHoles.add(hole);
                        break;
                    }
                    if (this.mKmlCurrentGroundOverlay == null) break;
                    this.mKmlCurrentGroundOverlay.setLatLonQuad(KmlDocument.parseKmlCoordinates(this.mStringBuilder.toString()));
                    break;
                }
                case gx_coord: {
                    if (this.mKmlCurrentGeometry == null || !(this.mKmlCurrentGeometry instanceof KmlTrack)) break;
                    ((KmlTrack)this.mKmlCurrentGeometry).addGxCoord(this.mStringBuilder.toString());
                    break;
                }
                case when: {
                    if (this.mKmlCurrentGeometry == null || !(this.mKmlCurrentGeometry instanceof KmlTrack)) break;
                    ((KmlTrack)this.mKmlCurrentGeometry).addWhen(this.mStringBuilder.toString());
                    break;
                }
                case styleUrl: {
                    String styleUrl = this.mStringBuilder.charAt(0) == '#' ? this.mStringBuilder.substring(1) : this.mStringBuilder.toString();
                    if (this.mCurrentStyleMap != null) {
                        this.mCurrentStyleMap.setPair(this.mCurrentStyleKey, styleUrl);
                        break;
                    }
                    if (this.mKmlCurrentFeature == null) break;
                    this.mKmlCurrentFeature.mStyle = styleUrl;
                    break;
                }
                case key: {
                    this.mCurrentStyleKey = this.mStringBuilder.toString();
                    break;
                }
                case color: {
                    if (this.mCurrentStyle != null) {
                        if (this.mColorStyle == null) break;
                        this.mColorStyle.mColor = ColorStyle.parseKMLColor(this.mStringBuilder.toString());
                        break;
                    }
                    if (this.mKmlCurrentGroundOverlay == null) break;
                    this.mKmlCurrentGroundOverlay.mColor = ColorStyle.parseKMLColor(this.mStringBuilder.toString());
                    break;
                }
                case colorMode: {
                    if (this.mCurrentStyle == null || this.mColorStyle == null) break;
                    this.mColorStyle.mColorMode = this.mStringBuilder.toString().equals("random") ? 1 : 0;
                    break;
                }
                case width: {
                    if (this.mCurrentStyle == null || this.mColorStyle == null || !(this.mColorStyle instanceof LineStyle)) break;
                    this.mCurrentStyle.mLineStyle.mWidth = Float.parseFloat(this.mStringBuilder.toString());
                    break;
                }
                case scale: {
                    if (this.mCurrentStyle == null || this.mColorStyle == null || !(this.mColorStyle instanceof IconStyle)) break;
                    this.mCurrentStyle.mIconStyle.mScale = Float.parseFloat(this.mStringBuilder.toString());
                    break;
                }
                case heading: {
                    if (this.mCurrentStyle == null || this.mColorStyle == null || !(this.mColorStyle instanceof IconStyle)) break;
                    this.mCurrentStyle.mIconStyle.mHeading = Float.parseFloat(this.mStringBuilder.toString());
                    break;
                }
                case href: {
                    if (this.mCurrentStyle != null && this.mColorStyle != null && this.mColorStyle instanceof IconStyle) {
                        String href = this.mStringBuilder.toString();
                        this.mCurrentStyle.setIcon(href, this.mFile, this.mKMZFile);
                        break;
                    }
                    if (this.mIsNetworkLink) {
                        String href = this.mStringBuilder.toString();
                        this.loadNetworkLink(href, this.mKMZFile);
                        break;
                    }
                    if (this.mKmlCurrentGroundOverlay == null) break;
                    this.mKmlCurrentGroundOverlay.setIcon(this.mStringBuilder.toString(), this.mFile, this.mKMZFile);
                    break;
                }
                case LineStyle: 
                case PolyStyle: 
                case IconStyle: {
                    this.mColorStyle = null;
                    break;
                }
                case Style: {
                    if (this.mCurrentStyleId != null) {
                        KmlDocument.this.putStyle(this.mCurrentStyleId, this.mCurrentStyle);
                    } else {
                        this.mCurrentStyleId = KmlDocument.this.addStyle(this.mCurrentStyle);
                    }
                    if (this.mKmlCurrentFeature != null && this.mKmlCurrentFeature != this.mKmlRoot) {
                        this.mKmlCurrentFeature.mStyle = this.mCurrentStyleId;
                    }
                    this.mCurrentStyle = null;
                    this.mCurrentStyleId = null;
                    break;
                }
                case StyleMap: {
                    if (this.mCurrentStyleId != null) {
                        KmlDocument.this.putStyle(this.mCurrentStyleId, this.mCurrentStyleMap);
                    }
                    this.mCurrentStyleMap = null;
                    this.mCurrentStyleId = null;
                    this.mCurrentStyleKey = null;
                    break;
                }
                case north: {
                    this.mNorth = Double.parseDouble(this.mStringBuilder.toString());
                    break;
                }
                case south: {
                    this.mSouth = Double.parseDouble(this.mStringBuilder.toString());
                    break;
                }
                case east: {
                    this.mEast = Double.parseDouble(this.mStringBuilder.toString());
                    break;
                }
                case west: {
                    this.mWest = Double.parseDouble(this.mStringBuilder.toString());
                    break;
                }
                case rotation: {
                    if (this.mKmlCurrentGroundOverlay == null) break;
                    this.mKmlCurrentGroundOverlay.mRotation = Float.parseFloat(this.mStringBuilder.toString());
                    break;
                }
                case LatLonBox: {
                    if (this.mKmlCurrentGroundOverlay == null) break;
                    this.mKmlCurrentGroundOverlay.setLatLonBox(this.mNorth, this.mSouth, this.mEast, this.mWest);
                    break;
                }
                case SimpleData: {
                    this.mKmlCurrentFeature.setExtendedData(this.mDataName, this.mStringBuilder.toString());
                    this.mDataName = null;
                    break;
                }
                case value: {
                    this.mKmlCurrentFeature.setExtendedData(this.mDataName, this.mStringBuilder.toString());
                    this.mDataName = null;
                    break;
                }
            }
        }
    }

    protected static enum KmlKeywords {
        Document,
        Folder,
        NetworkLink,
        GroundOverlay,
        Placemark,
        Point,
        LineString,
        gx_Track,
        Polygon,
        innerBoundaryIs,
        MultiGeometry,
        Style,
        StyleMap,
        LineStyle,
        PolyStyle,
        IconStyle,
        hotSpot,
        Data,
        SimpleData,
        name,
        description,
        visibility,
        open,
        coordinates,
        gx_coord,
        when,
        styleUrl,
        key,
        color,
        colorMode,
        width,
        scale,
        heading,
        href,
        north,
        south,
        east,
        west,
        rotation,
        LatLonBox,
        gx_LatLonQuad,
        value,
        id;

    }
}

