/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;

public class ColorStyle
implements Parcelable {
    static final int MODE_NORMAL = 0;
    static final int MODE_RANDOM = 1;
    public int mColor;
    public int mColorMode;
    public static final Parcelable.Creator<ColorStyle> CREATOR = new Parcelable.Creator<ColorStyle>(){

        public ColorStyle createFromParcel(Parcel source) {
            return new ColorStyle(source);
        }

        public ColorStyle[] newArray(int size) {
            return new ColorStyle[size];
        }
    };

    public ColorStyle() {
        this(0);
    }

    ColorStyle(int color) {
        this.mColor = color;
        this.mColorMode = 0;
    }

    public static int parseKMLColor(String sColor) {
        sColor = sColor.trim();
        while (sColor.length() < 8) {
            sColor = "0" + sColor;
        }
        String aa = sColor.substring(0, 2);
        String bb = sColor.substring(2, 4);
        String gg = sColor.substring(4, 6);
        String rr = sColor.substring(6, 8);
        sColor = "#" + aa + rr + gg + bb;
        int iColor = -16777216;
        try {
            iColor = Color.parseColor((String)sColor);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return iColor;
    }

    public static String colorAsKMLString(int aColor) {
        return String.format("%02X%02X%02X%02X", Color.alpha((int)aColor), Color.blue((int)aColor), Color.green((int)aColor), Color.red((int)aColor));
    }

    public static String colorAsAndroidString(int aColor) {
        return String.format("#%08X", 0xFFFFFFFF & aColor);
    }

    public String colorAsAndroidString() {
        return ColorStyle.colorAsAndroidString(this.mColor);
    }

    public int getFinalColor() {
        if (this.mColorMode == 0) {
            return this.mColor;
        }
        int alpha = Color.alpha((int)this.mColor);
        double randomRange = Math.random();
        int red = Color.red((int)this.mColor);
        red = (int)((double)red * randomRange);
        int green = Color.green((int)this.mColor);
        green = (int)((double)green * randomRange);
        int blue = Color.blue((int)this.mColor);
        blue = (int)((double)blue * randomRange);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public void writeAsKML(Writer writer) {
        try {
            writer.write("<color>" + ColorStyle.colorAsKMLString(this.mColor) + "</color>\n");
            if (this.mColorMode == 1) {
                writer.write("<colorMode>random</colorMode>\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mColor);
        out.writeInt(this.mColorMode);
    }

    public ColorStyle(Parcel in) {
        this.mColor = in.readInt();
        this.mColorMode = in.readInt();
    }
}

