/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.clustering;

import java.util.ArrayList;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.overlay.Marker;

public class StaticCluster {
    protected final ArrayList<Marker> mItems = new ArrayList();
    protected GeoPoint mCenter;
    protected Marker mMarker;

    public StaticCluster(GeoPoint center) {
        this.mCenter = center;
    }

    public void setPosition(GeoPoint center) {
        this.mCenter = center;
    }

    public GeoPoint getPosition() {
        return this.mCenter;
    }

    public int getSize() {
        return this.mItems.size();
    }

    public Marker getItem(int index) {
        return this.mItems.get(index);
    }

    public boolean add(Marker t) {
        return this.mItems.add(t);
    }

    public void setMarker(Marker marker) {
        this.mMarker = marker;
    }

    public Marker getMarker() {
        return this.mMarker;
    }

    public BoundingBox getBoundingBox() {
        if (this.getSize() == 0) {
            return null;
        }
        GeoPoint p = this.getItem(0).getPosition();
        BoundingBox bb = new BoundingBox(p.getLatitude(), p.getLongitude(), p.getLatitude(), p.getLongitude());
        for (int i = 1; i < this.getSize(); ++i) {
            p = this.getItem(i).getPosition();
            double minLat = Math.min(bb.getLatSouth(), p.getLatitude());
            double minLon = Math.min(bb.getLonWest(), p.getLongitude());
            double maxLat = Math.max(bb.getLatNorth(), p.getLatitude());
            double maxLon = Math.max(bb.getLonEast(), p.getLongitude());
            bb.set(maxLat, maxLon, minLat, minLon);
        }
        return bb;
    }
}

