/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.clustering;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.bonuspack.R;
import org.osmdroid.bonuspack.clustering.MarkerClusterer;
import org.osmdroid.bonuspack.clustering.StaticCluster;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Marker;

public class RadiusMarkerClusterer
extends MarkerClusterer {
    protected int mMaxClusteringZoomLevel = 17;
    protected int mRadiusInPixels = 100;
    protected double mRadiusInMeters;
    protected Paint mTextPaint = new Paint();
    private ArrayList<Marker> mClonedMarkers;
    protected boolean mAnimated;
    int mDensityDpi;
    public float mAnchorU = 0.5f;
    public float mAnchorV = 0.5f;
    public float mTextAnchorU = 0.5f;
    public float mTextAnchorV = 0.5f;

    public RadiusMarkerClusterer(Context ctx) {
        this.mTextPaint.setColor(-1);
        this.mTextPaint.setTextSize(15.0f * ctx.getResources().getDisplayMetrics().density);
        this.mTextPaint.setFakeBoldText(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setAntiAlias(true);
        Drawable clusterIconD = ctx.getResources().getDrawable(R.drawable.marker_cluster);
        Bitmap clusterIcon = ((BitmapDrawable)clusterIconD).getBitmap();
        this.setIcon(clusterIcon);
        this.mAnimated = true;
        this.mDensityDpi = ctx.getResources().getDisplayMetrics().densityDpi;
    }

    public Paint getTextPaint() {
        return this.mTextPaint;
    }

    public void setRadius(int radius) {
        this.mRadiusInPixels = radius;
    }

    public void setMaxClusteringZoomLevel(int zoom) {
        this.mMaxClusteringZoomLevel = zoom;
    }

    @Override
    public ArrayList<StaticCluster> clusterer(MapView mapView) {
        ArrayList<StaticCluster> clusters = new ArrayList<StaticCluster>();
        this.convertRadiusToMeters(mapView);
        this.mClonedMarkers = new ArrayList(this.mItems);
        while (!this.mClonedMarkers.isEmpty()) {
            Marker m = this.mClonedMarkers.get(0);
            StaticCluster cluster = this.createCluster(m, mapView);
            clusters.add(cluster);
        }
        return clusters;
    }

    private StaticCluster createCluster(Marker m, MapView mapView) {
        GeoPoint clusterPosition = m.getPosition();
        StaticCluster cluster = new StaticCluster(clusterPosition);
        cluster.add(m);
        this.mClonedMarkers.remove(m);
        if (mapView.getZoomLevel() > this.mMaxClusteringZoomLevel) {
            return cluster;
        }
        Iterator<Marker> it = this.mClonedMarkers.iterator();
        while (it.hasNext()) {
            Marker neighbour = it.next();
            double distance = clusterPosition.distanceToAsDouble((IGeoPoint)neighbour.getPosition());
            if (!(distance <= this.mRadiusInMeters)) continue;
            cluster.add(neighbour);
            it.remove();
        }
        return cluster;
    }

    @Override
    public Marker buildClusterMarker(StaticCluster cluster, MapView mapView) {
        Marker m = new Marker(mapView);
        m.setPosition(cluster.getPosition());
        m.setInfoWindow(null);
        m.setAnchor(this.mAnchorU, this.mAnchorV);
        Bitmap finalIcon = Bitmap.createBitmap((int)this.mClusterIcon.getScaledWidth(this.mDensityDpi), (int)this.mClusterIcon.getScaledHeight(this.mDensityDpi), (Bitmap.Config)this.mClusterIcon.getConfig());
        Canvas iconCanvas = new Canvas(finalIcon);
        iconCanvas.drawBitmap(this.mClusterIcon, 0.0f, 0.0f, null);
        String text = "" + cluster.getSize();
        int textHeight = (int)(this.mTextPaint.descent() + this.mTextPaint.ascent());
        iconCanvas.drawText(text, this.mTextAnchorU * (float)finalIcon.getWidth(), this.mTextAnchorV * (float)finalIcon.getHeight() - (float)(textHeight / 2), this.mTextPaint);
        m.setIcon((Drawable)new BitmapDrawable(mapView.getContext().getResources(), finalIcon));
        return m;
    }

    @Override
    public void renderer(ArrayList<StaticCluster> clusters, Canvas canvas, MapView mapView) {
        for (StaticCluster cluster : clusters) {
            if (cluster.getSize() == 1) {
                cluster.setMarker(cluster.getItem(0));
                continue;
            }
            Marker m = this.buildClusterMarker(cluster, mapView);
            cluster.setMarker(m);
        }
    }

    private void convertRadiusToMeters(MapView mapView) {
        Rect mScreenRect = mapView.getIntrinsicScreenRect(null);
        int screenWidth = mScreenRect.right - mScreenRect.left;
        int screenHeight = mScreenRect.bottom - mScreenRect.top;
        BoundingBox bb = mapView.getBoundingBox();
        double diagonalInMeters = bb.getDiagonalLengthInMeters();
        double diagonalInPixels = Math.sqrt(screenWidth * screenWidth + screenHeight * screenHeight);
        double metersInPixel = diagonalInMeters / diagonalInPixels;
        this.mRadiusInMeters = (double)this.mRadiusInPixels * metersInPixel;
    }

    public void setAnimation(boolean animate) {
        this.mAnimated = animate;
    }

    public void zoomOnCluster(MapView mapView, StaticCluster cluster) {
        BoundingBox bb = cluster.getBoundingBox();
        if (bb.getLatNorth() != bb.getLatSouth() || bb.getLonEast() != bb.getLonWest()) {
            bb = bb.increaseByScale(1.15f);
            mapView.zoomToBoundingBox(bb, true);
        } else {
            mapView.setExpectedCenter((IGeoPoint)bb.getCenterWithDateLine());
        }
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.reversedClusters()) {
            if (!cluster.getMarker().onSingleTapConfirmed(event, mapView)) continue;
            if (this.mAnimated && cluster.getSize() > 1) {
                this.zoomOnCluster(mapView, cluster);
            }
            return true;
        }
        return false;
    }
}

