/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.process.command;

import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.process.Command;
import com.thebuzzmedia.exiftool.process.command.DefaultCommand;
import java.util.ArrayList;
import java.util.List;

public class CommandBuilder {
    private final String executable;
    private final List<String> arguments;

    public static CommandBuilder builder(String executable) {
        return CommandBuilder.builder(executable, 10);
    }

    public static CommandBuilder builder(String executable, int nbArgs) {
        return new CommandBuilder(executable, nbArgs);
    }

    private CommandBuilder(String executable, int size) {
        this.executable = PreConditions.notBlank(executable, "Command line executable should be defined");
        this.arguments = new ArrayList<String>(size);
    }

    public CommandBuilder addArgument(String arg, String ... args) {
        this.add(arg);
        if (args.length > 0) {
            for (String a : args) {
                this.add(a);
            }
        }
        return this;
    }

    public CommandBuilder addAll(Iterable<String> arguments) {
        PreConditions.notEmpty(arguments, "Arguments should not be empty");
        for (String arg : arguments) {
            this.add(arg);
        }
        return this;
    }

    public Command build() {
        return new DefaultCommand(this.executable, this.arguments);
    }

    private void add(String arg) {
        this.arguments.add(PreConditions.notBlank(arg, "Command line argument should be defined if set"));
    }
}

