/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.iterables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class Collections {
    private Collections() {
    }

    public static <T> boolean isEmpty(Collection<T> values) {
        return values == null || values.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> values) {
        return !Collections.isEmpty(values);
    }

    public static <T> int size(Collection<T> values) {
        return values == null ? 0 : values.size();
    }

    public static <T> Collection<T> toCollection(Iterable<T> iterables) {
        if (iterables == null) {
            return new ArrayList(0);
        }
        if (iterables instanceof Collection) {
            return (Collection)iterables;
        }
        return StreamSupport.stream(iterables.spliterator(), false).collect(Collectors.toList());
    }

    public static <T> void addAll(Collection<T> collection, Iterable<T> iterable) {
        if (iterable == null || collection == null) {
            return;
        }
        for (T value : iterable) {
            collection.add(value);
        }
    }
}

