/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool;

import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.commons.lang.Strings;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(String version) {
        PreConditions.notBlank(version, "Version number should be set");
        String[] parts = version.split("[ .,]+");
        this.major = Strings.tryParseInt(parts[0]).orElse(0);
        this.minor = parts.length >= 2 ? Strings.tryParseInt(parts[1]).orElse(0) : 0;
        this.patch = parts.length >= 3 ? Strings.tryParseInt(parts[2]).orElse(0) : 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Version) {
            Version v = (Version)o;
            return Objects.equals(v.major, this.major) && Objects.equals(v.minor, this.minor) && Objects.equals(v.patch, this.patch);
        }
        return false;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(Version version) {
        int result = Integer.compare(this.major, version.major);
        if (result == 0 && (result = Integer.compare(this.minor, version.minor)) == 0) {
            result = Integer.compare(this.patch, version.patch);
        }
        return result;
    }
}

