/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.strategies;

import com.thebuzzmedia.exiftool.ExecutionStrategy;
import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.exceptions.PoolIOException;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.OutputHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class PoolStrategy
implements ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(PoolStrategy.class);
    private final int poolSize;
    private final BlockingQueue<ExecutionStrategy> pool;

    public PoolStrategy(Collection<ExecutionStrategy> strategies) {
        PreConditions.notEmpty(strategies, "Pool must not be empty");
        this.poolSize = strategies.size();
        this.pool = new LinkedBlockingDeque<ExecutionStrategy>(strategies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandExecutor executor, String exifTool, List<String> arguments, OutputHandler handler) throws IOException {
        ExecutionStrategy strategy = null;
        try {
            strategy = this.pool.take();
            strategy.execute(executor, exifTool, arguments, handler);
        }
        catch (InterruptedException ex) {
            log.warn(ex.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            if (strategy != null) {
                this.pool.offer(strategy);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.pool.size() < this.poolSize;
    }

    @Override
    public boolean isSupported(Version version) {
        for (ExecutionStrategy strategy : this.pool) {
            if (strategy.isSupported(version)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.processPool((strategy, i) -> {
            log.debug("Closing strategy #{}", i);
            strategy.close();
        });
    }

    @Override
    public void shutdown() throws Exception {
        this.processPool((strategy, i) -> {
            log.debug("Closing strategy #{}", i);
            strategy.shutdown();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPool(ExecutionStrategyFunction function) throws Exception {
        ArrayList<ExecutionStrategy> strategies = new ArrayList<ExecutionStrategy>(this.poolSize);
        log.debug("Retrieve all pending strategies");
        int added = 0;
        while (added != this.poolSize) {
            try {
                if ((added += this.pool.drainTo(strategies)) >= this.poolSize) continue;
                ExecutionStrategy strategy = this.pool.take();
                strategies.add(strategy);
                ++added;
            }
            catch (InterruptedException ex) {
                log.warn(ex.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        ArrayList<Exception> thrownEx = new ArrayList<Exception>(strategies.size());
        int i = 0;
        for (ExecutionStrategy strategy : strategies) {
            try {
                function.apply(strategy, i);
            }
            catch (Exception ex) {
                log.error("Failed to process strategy #{}", i);
                thrownEx.add(ex);
            }
            finally {
                ++i;
                this.pool.offer(strategy);
            }
        }
        if (thrownEx.size() > 0) {
            throw new PoolIOException("Some strategies in the pool failed to close properly", thrownEx);
        }
    }

    private static interface ExecutionStrategyFunction {
        public void apply(ExecutionStrategy var1, int var2) throws Exception;
    }
}

