/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.schedulers;

import com.thebuzzmedia.exiftool.Scheduler;
import com.thebuzzmedia.exiftool.commons.lang.Objects;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import java.util.Timer;
import java.util.TimerTask;

public class TimerScheduler
implements Scheduler {
    private final String name;
    private final long delay;
    private final Timer timer;
    private TimerTask pendingTask;

    public TimerScheduler(String name, long delay) {
        this.name = Objects.firstNonNull(name, "ExifTool Cleanup Timer", new String[0]);
        this.delay = PreConditions.isPositive(delay, "Delay must be strictly positive");
        this.timer = new Timer(this.name, true);
    }

    @Override
    public synchronized void start(Runnable runnable) {
        this.pendingTask = new CleanupTask(runnable);
        this.timer.schedule(this.pendingTask, this.delay);
    }

    @Override
    public synchronized void stop() {
        if (this.pendingTask != null) {
            this.pendingTask.cancel();
            this.timer.purge();
            this.pendingTask = null;
        }
    }

    @Override
    public synchronized void shutdown() {
        this.stop();
        this.timer.cancel();
    }

    private static class CleanupTask
    extends TimerTask {
        private final Runnable runnable;

        private CleanupTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

