/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.gc;

import com.thebuzzmedia.exiftool.commons.gc.Cleaner;
import com.thebuzzmedia.exiftool.commons.reflection.ClassUtils;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

final class UnsafeCleaner
implements Cleaner {
    private final MethodHandle register;

    static UnsafeCleaner create() {
        Class<?> cleanerClass = ClassUtils.lookupClass("sun.misc.Cleaner");
        MethodHandle register = ClassUtils.findStaticMethod(cleanerClass, "create", cleanerClass, Object.class, Runnable.class);
        return new UnsafeCleaner(register);
    }

    private UnsafeCleaner(MethodHandle register) {
        this.register = Objects.requireNonNull(register, "Register method must not be null");
    }

    @Override
    public void register(Object ref, Runnable cleanupTask) {
        ClassUtils.invokeStatic(this.register, ref, cleanupTask);
    }
}

