/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.gc;

import com.thebuzzmedia.exiftool.commons.gc.Cleaner;
import com.thebuzzmedia.exiftool.commons.reflection.ClassUtils;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

final class JdkCleaner
implements Cleaner {
    private final Object cleaner;
    private final MethodHandle register;

    static JdkCleaner create() {
        Class<?> cleanerClass = ClassUtils.lookupClass("java.lang.ref.Cleaner");
        Class<?> cleanableClass = ClassUtils.lookupClass("java.lang.ref.Cleaner$Cleanable");
        MethodHandle create = ClassUtils.findStaticMethod(cleanerClass, "create", cleanerClass, new Class[0]);
        Object cleaner = ClassUtils.invokeStatic(create, new Object[0]);
        MethodHandle register = ClassUtils.findMethod(cleanerClass, "register", cleanableClass, Object.class, Runnable.class);
        return new JdkCleaner(cleaner, register);
    }

    private JdkCleaner(Object cleaner, MethodHandle register) {
        this.cleaner = Objects.requireNonNull(cleaner, "Cleaner must not be null");
        this.register = Objects.requireNonNull(register, "Register method must not be null");
    }

    @Override
    public void register(Object ref, Runnable cleanupTask) {
        ClassUtils.invoke(this.register, this.cleaner, ref, cleanupTask);
    }
}

