/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.server.http;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.server.http.UsbFileHttpServer;
import com.github.mjdev.libaums.server.http.server.HttpServer;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0010H\u0004J,\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u0010H\u0007J\b\u0010\u001e\u001a\u00020\u0016H\u0004J\u0006\u0010\u001f\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/github/mjdev/libaums/server/http/UsbFileHttpServerService;", "Landroid/app/Service;", "()V", "isServerRunning", "", "()Z", "server", "Lcom/github/mjdev/libaums/server/http/UsbFileHttpServer;", "getServer", "()Lcom/github/mjdev/libaums/server/http/UsbFileHttpServer;", "setServer", "(Lcom/github/mjdev/libaums/server/http/UsbFileHttpServer;)V", "createNotificationChannel", "", "id", "name", "", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "startAsForeground", "", "notificationId", "notificationName", "startServer", "file", "Lcom/github/mjdev/libaums/fs/UsbFile;", "Lcom/github/mjdev/libaums/server/http/server/HttpServer;", "notificationChannelId", "stopForeground", "stopServer", "Companion", "ServiceBinder", "libaums-httpserver_release"})
public final class UsbFileHttpServerService
extends Service {
    @Nullable
    private UsbFileHttpServer server;
    private static final String TAG;
    private static final int ONGOING_NOTIFICATION_ID = 1;
    public static final Companion Companion;

    @Nullable
    public final UsbFileHttpServer getServer() {
        return this.server;
    }

    public final void setServer(@Nullable UsbFileHttpServer usbFileHttpServer) {
        this.server = usbFileHttpServer;
    }

    public final boolean isServerRunning() {
        UsbFileHttpServer usbFileHttpServer = this.server;
        return usbFileHttpServer != null ? usbFileHttpServer.isAlive() : false;
    }

    @JvmOverloads
    public final void startServer(@NotNull UsbFile file, @NotNull HttpServer server, @NotNull String notificationChannelId, @NotNull CharSequence notificationName) throws IOException {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)notificationChannelId, (String)"notificationChannelId");
            Intrinsics.checkParameterIsNotNull((Object)notificationName, (String)"notificationName");
            this.startAsForeground(notificationChannelId, notificationName);
            UsbFileHttpServer usbFileHttpServer = this.server = new UsbFileHttpServer(file, server);
            if (usbFileHttpServer == null) break block0;
            usbFileHttpServer.start();
        }
    }

    public static /* synthetic */ void startServer$default(UsbFileHttpServerService usbFileHttpServerService, UsbFile usbFile, HttpServer httpServer, String string, CharSequence charSequence, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            string = "com.github.magnusja.libaums.http_service_channel";
        }
        if ((n & 8) != 0) {
            charSequence = "libaums_http";
        }
        usbFileHttpServerService.startServer(usbFile, httpServer, string, charSequence);
    }

    @JvmOverloads
    public final void startServer(@NotNull UsbFile file, @NotNull HttpServer server, @NotNull String notificationChannelId) throws IOException {
        UsbFileHttpServerService.startServer$default(this, file, server, notificationChannelId, null, 8, null);
    }

    @JvmOverloads
    public final void startServer(@NotNull UsbFile file, @NotNull HttpServer server) throws IOException {
        UsbFileHttpServerService.startServer$default(this, file, server, null, null, 12, null);
    }

    public final void stopServer() {
        try {
            UsbFileHttpServer usbFileHttpServer = this.server;
            if (usbFileHttpServer != null) {
                usbFileHttpServer.stop();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"exception stopping server", (Throwable)e);
        }
        this.stopForeground();
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        return (IBinder)new ServiceBinder();
    }

    protected final void startAsForeground(@NotNull String notificationId, @NotNull CharSequence notificationName) {
        Intrinsics.checkParameterIsNotNull((Object)notificationId, (String)"notificationId");
        Intrinsics.checkParameterIsNotNull((Object)notificationName, (String)"notificationName");
        String channelId = "";
        if (Build.VERSION.SDK_INT >= 26) {
            channelId = this.createNotificationChannel(notificationId, notificationName);
        }
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder((Context)this, channelId);
        Notification notification = notificationBuilder.setOngoing(true).setCategory("service").setContentTitle((CharSequence)"Serving via HTTP").build();
        this.startForeground(1, notification);
    }

    @RequiresApi(value=26)
    private final String createNotificationChannel(String id, CharSequence name) {
        NotificationChannel chan = new NotificationChannel(id, name, 2);
        chan.setLightColor(-16776961);
        chan.setLockscreenVisibility(0);
        Object object = this.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager service = (NotificationManager)object;
        service.createNotificationChannel(chan);
        return id;
    }

    protected final void stopForeground() {
        this.stopForeground(true);
    }

    static {
        Companion = new Companion(null);
        String string = UsbFileHttpServerService.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UsbFileHttpServerService::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/mjdev/libaums/server/http/UsbFileHttpServerService$ServiceBinder;", "Landroid/os/Binder;", "(Lcom/github/mjdev/libaums/server/http/UsbFileHttpServerService;)V", "service", "Lcom/github/mjdev/libaums/server/http/UsbFileHttpServerService;", "getService", "()Lcom/github/mjdev/libaums/server/http/UsbFileHttpServerService;", "libaums-httpserver_release"})
    public final class ServiceBinder
    extends Binder {
        @NotNull
        public final UsbFileHttpServerService getService() {
            return UsbFileHttpServerService.this;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/mjdev/libaums/server/http/UsbFileHttpServerService$Companion;", "", "()V", "ONGOING_NOTIFICATION_ID", "", "TAG", "", "libaums-httpserver_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

