/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectory;
import com.github.mjdev.libaums.fs.fat32.FsInfoStructure;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R\u0014\u0010%\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/Fat32FileSystem;", "Lcom/github/mjdev/libaums/fs/FileSystem;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "first512Bytes", "Ljava/nio/ByteBuffer;", "(Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;Ljava/nio/ByteBuffer;)V", "bootSector", "Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "capacity", "", "getCapacity", "()J", "chunkSize", "", "getChunkSize", "()I", "fat", "Lcom/github/mjdev/libaums/fs/fat32/FAT;", "fileCache", "Ljava/util/WeakHashMap;", "", "Lcom/github/mjdev/libaums/fs/UsbFile;", "getFileCache$libaums_release", "()Ljava/util/WeakHashMap;", "freeSpace", "getFreeSpace", "fsInfoStructure", "Lcom/github/mjdev/libaums/fs/fat32/FsInfoStructure;", "occupiedSpace", "getOccupiedSpace", "rootDirectory", "Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;", "getRootDirectory", "()Lcom/github/mjdev/libaums/fs/fat32/FatDirectory;", "type", "getType", "volumeLabel", "getVolumeLabel", "()Ljava/lang/String;", "Companion", "libaums_release"})
public final class Fat32FileSystem
implements FileSystem {
    private final Fat32BootSector bootSector;
    private final FAT fat;
    private final FsInfoStructure fsInfoStructure;
    @NotNull
    private final FatDirectory rootDirectory;
    @NotNull
    private final WeakHashMap<String, UsbFile> fileCache;
    private static final String TAG;
    public static final Companion Companion;

    @Override
    @NotNull
    public FatDirectory getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public final WeakHashMap<String, UsbFile> getFileCache$libaums_release() {
        return this.fileCache;
    }

    @Override
    @NotNull
    public String getVolumeLabel() {
        String string;
        boolean bl;
        String string2;
        String string3 = this.getRootDirectory().getVolumeLabel$libaums_release();
        if (string3 != null) {
            string2 = string3;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            string = it;
        } else {
            string = null;
        }
        string2 = string;
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        return string4;
    }

    @Override
    public long getCapacity() {
        return this.bootSector.getTotalNumberOfSectors() * (long)this.bootSector.getBytesPerSector();
    }

    @Override
    public long getOccupiedSpace() {
        return this.getCapacity() - this.getFreeSpace();
    }

    @Override
    public long getFreeSpace() {
        return this.fsInfoStructure.getFreeClusterCount() * (long)this.bootSector.getBytesPerCluster();
    }

    @Override
    public int getChunkSize() {
        return this.bootSector.getBytesPerCluster();
    }

    @Override
    public int getType() {
        return 2;
    }

    private Fat32FileSystem(BlockDeviceDriver blockDevice, ByteBuffer first512Bytes) throws IOException {
        this.bootSector = Fat32BootSector.Companion.read(first512Bytes);
        this.fileCache = new WeakHashMap();
        this.fsInfoStructure = FsInfoStructure.Companion.read(blockDevice, this.bootSector.getFsInfoStartSector() * this.bootSector.getBytesPerSector());
        this.fat = new FAT(blockDevice, this.bootSector, this.fsInfoStructure);
        this.rootDirectory = FatDirectory.Companion.readRoot$libaums_release(this, blockDevice, this.fat, this.bootSector);
        Log.d((String)TAG, (String)this.bootSector.toString());
    }

    static {
        Companion = new Companion(null);
        String string = Fat32FileSystem.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Fat32FileSystem::class.java.simpleName");
        TAG = string;
    }

    public /* synthetic */ Fat32FileSystem(BlockDeviceDriver blockDevice, ByteBuffer first512Bytes, DefaultConstructorMarker $constructor_marker) {
        this(blockDevice, first512Bytes);
    }

    @JvmStatic
    @Nullable
    public static final Fat32FileSystem read(@NotNull BlockDeviceDriver blockDevice) throws IOException {
        return Companion.read(blockDevice);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/Fat32FileSystem$Companion;", "", "()V", "TAG", "", "read", "Lcom/github/mjdev/libaums/fs/fat32/Fat32FileSystem;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "libaums_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Fat32FileSystem read(@NotNull BlockDeviceDriver blockDevice) throws IOException {
            ByteBuffer buffer;
            Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
            ByteBuffer byteBuffer = buffer = ByteBuffer.allocate(512);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            blockDevice.read(0L, byteBuffer);
            buffer.flip();
            return (char)buffer.get(82) != 'F' || (char)buffer.get(83) != 'A' || (char)buffer.get(84) != 'T' || (char)buffer.get(85) != '3' || (char)buffer.get(86) != '2' || (char)buffer.get(87) != ' ' || (char)buffer.get(88) != ' ' || (char)buffer.get(89) != ' ' ? null : new Fat32FileSystem(blockDevice, buffer, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

