/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.fs;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.partition.PartitionTable;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.util.ArrayList;
import java.util.List;

public class FileSystemPartitionTable
implements PartitionTable {
    private static final String TAG = FileSystemPartitionTable.class.getSimpleName();
    List<PartitionTableEntry> entries = new ArrayList<PartitionTableEntry>();

    public FileSystemPartitionTable(BlockDeviceDriver blockDevice, FileSystem fs) {
        Log.i((String)TAG, (String)"Found a device without partition table, yay!");
        int totalNumberOfSectors = (int)fs.getCapacity() / blockDevice.getBlockSize();
        if (fs.getCapacity() % (long)blockDevice.getBlockSize() != 0L) {
            Log.w((String)TAG, (String)"fs capacity is not multiple of block size");
        }
        this.entries.add(new PartitionTableEntry(fs.getType(), 0, totalNumberOfSectors));
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.entries;
    }
}

