/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemFactory;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Partition
implements BlockDeviceDriver {
    private static final String TAG = Partition.class.getSimpleName();
    private BlockDeviceDriver blockDevice;
    private int logicalBlockAddress;
    private int blockSize;
    private FileSystem fileSystem;

    private Partition() {
    }

    public static Partition createPartition(PartitionTableEntry entry, BlockDeviceDriver blockDevice) throws IOException {
        Partition partition = null;
        partition = new Partition();
        partition.logicalBlockAddress = entry.getLogicalBlockAddress();
        partition.blockDevice = blockDevice;
        partition.blockSize = blockDevice.getBlockSize();
        try {
            partition.fileSystem = FileSystemFactory.createFileSystem(entry, partition);
        }
        catch (FileSystemFactory.UnsupportedFileSystemException e) {
            Log.w((String)TAG, (String)"Unsupported fs on partition");
        }
        return partition.fileSystem != null ? partition : null;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getVolumeLabel() {
        return this.fileSystem.getVolumeLabel();
    }

    @Override
    public void init() {
    }

    @Override
    public void read(long offset, ByteBuffer dest) throws IOException {
        long devOffset = offset / (long)this.blockSize + (long)this.logicalBlockAddress;
        if (offset % (long)this.blockSize != 0L) {
            ByteBuffer tmp = ByteBuffer.allocate(this.blockSize);
            this.blockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(offset % (long)this.blockSize));
            int limit = Math.min(dest.remaining(), tmp.remaining());
            tmp.limit(tmp.position() + limit);
            dest.put(tmp);
            ++devOffset;
        }
        if (dest.remaining() > 0) {
            ByteBuffer buffer;
            if (dest.remaining() % this.blockSize != 0) {
                int rounded = this.blockSize - dest.remaining() % this.blockSize + dest.remaining();
                buffer = ByteBuffer.allocate(rounded);
                buffer.limit(rounded);
            } else {
                buffer = dest;
            }
            this.blockDevice.read(devOffset, buffer);
            if (dest.remaining() % this.blockSize != 0) {
                System.arraycopy(buffer.array(), 0, dest.array(), dest.position(), dest.remaining());
            }
        }
    }

    @Override
    public void write(long offset, ByteBuffer src) throws IOException {
        long devOffset = offset / (long)this.blockSize + (long)this.logicalBlockAddress;
        if (offset % (long)this.blockSize != 0L) {
            ByteBuffer tmp = ByteBuffer.allocate(this.blockSize);
            this.blockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(offset % (long)this.blockSize));
            int remaining = Math.min(tmp.remaining(), src.remaining());
            tmp.put(src.array(), src.position(), remaining);
            src.position(src.position() + remaining);
            tmp.clear();
            this.blockDevice.write(devOffset, tmp);
            ++devOffset;
        }
        if (src.remaining() > 0) {
            ByteBuffer buffer;
            if (src.remaining() % this.blockSize != 0) {
                int rounded = this.blockSize - src.remaining() % this.blockSize + src.remaining();
                buffer = ByteBuffer.allocate(rounded);
                buffer.limit(rounded);
                System.arraycopy(src.array(), src.position(), buffer.array(), 0, src.remaining());
            } else {
                buffer = src;
            }
            this.blockDevice.write(devOffset, buffer);
        }
    }

    @Override
    public int getBlockSize() {
        return this.blockDevice.getBlockSize();
    }
}

