/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import com.github.mjdev.libaums.fs.fat32.FatDirectory;
import com.github.mjdev.libaums.fs.fat32.FsInfoStructure;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Fat32FileSystem
implements FileSystem {
    private static final String TAG = Fat32FileSystem.class.getSimpleName();
    private Fat32BootSector bootSector;
    private FAT fat;
    private FsInfoStructure fsInfoStructure;
    private FatDirectory rootDirectory;

    private Fat32FileSystem(BlockDeviceDriver blockDevice) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        blockDevice.read(0L, buffer);
        this.bootSector = Fat32BootSector.read(buffer);
        this.fsInfoStructure = FsInfoStructure.read(blockDevice, this.bootSector.getFsInfoStartSector() * this.bootSector.getBytesPerSector());
        this.fat = new FAT(blockDevice, this.bootSector, this.fsInfoStructure);
        this.rootDirectory = FatDirectory.readRoot(blockDevice, this.fat, this.bootSector);
        Log.d((String)TAG, (String)this.bootSector.toString());
    }

    public static Fat32FileSystem read(BlockDeviceDriver blockDevice) throws IOException {
        return new Fat32FileSystem(blockDevice);
    }

    @Override
    public UsbFile getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public String getVolumeLabel() {
        String volumeLabel = this.rootDirectory.getVolumeLabel();
        if (volumeLabel == null) {
            volumeLabel = this.bootSector.getVolumeLabel();
        }
        return volumeLabel;
    }

    @Override
    public long getCapacity() {
        return this.bootSector.getTotalNumberOfSectors() * (long)this.bootSector.getBytesPerSector();
    }

    @Override
    public long getOccupiedSpace() {
        return this.getCapacity() - this.getFreeSpace();
    }

    @Override
    public long getFreeSpace() {
        return this.fsInfoStructure.getFreeClusterCount() * (long)this.bootSector.getBytesPerCluster();
    }

    @Override
    public int getChunkSize() {
        return this.bootSector.getBytesPerCluster();
    }
}

