/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.server.http;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.github.mjdev.libaums.fs.UsbFile;
import com.github.mjdev.libaums.server.http.UsbFileHttpServer;
import java.io.IOException;

public class UsbFileHttpServerService
extends Service {
    private static final int ONGOING_NOTIFICATION_ID = 1;
    protected UsbFileHttpServer server;

    public void startServer(UsbFile file) throws IOException {
        this.startAsForeground();
        this.server = new UsbFileHttpServer(file);
        this.server.start();
    }

    public void stopServer() {
        this.server.stop();
        this.stopForeground();
    }

    public boolean isServerRunning() {
        return this.server != null && this.server.isAlive();
    }

    public UsbFileHttpServer getServer() {
        return this.server;
    }

    public void setServer(UsbFileHttpServer server) {
        this.server = server;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new ServiceBinder();
    }

    protected void startAsForeground() {
        Notification notification = new Notification.Builder((Context)this).setContentTitle((CharSequence)"Serving via HTTP").build();
        this.startForeground(1, notification);
    }

    protected void stopForeground() {
        this.stopForeground(true);
    }

    public class ServiceBinder
    extends Binder {
        public UsbFileHttpServerService getService() {
            return UsbFileHttpServerService.this;
        }
    }
}

