/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import com.github.mjdev.libaums.fs.fat32.ShortName;
import java.util.Collection;
import java.util.Locale;

class ShortNameGenerator {
    ShortNameGenerator() {
    }

    private static boolean isValidChar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == '$' || c == '%' || c == '\'' || c == '-' || c == '_' || c == '@' || c == '~' || c == '`' || c == '!' || c == '(' || c == ')' || c == '{' || c == '}' || c == '^' || c == '#' || c == '&';
    }

    private static boolean containsInvalidChars(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (ShortNameGenerator.isValidChar(c)) continue;
            return true;
        }
        return false;
    }

    private static String replaceInvalidChars(String str) {
        int length = str.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (ShortNameGenerator.isValidChar(c)) {
                builder.append(c);
                continue;
            }
            builder.append("_");
        }
        return builder.toString();
    }

    static ShortName generateShortName(String lfnName, Collection<ShortName> existingShortNames) {
        String extension;
        String name;
        int i;
        lfnName = lfnName.toUpperCase(Locale.ROOT).trim();
        for (i = 0; i < lfnName.length() && lfnName.charAt(i) == '.'; ++i) {
        }
        lfnName = lfnName.substring(i);
        int periodIndex = lfnName.lastIndexOf(46);
        boolean losslyConversion = false;
        if (periodIndex == -1) {
            if (ShortNameGenerator.containsInvalidChars(lfnName)) {
                losslyConversion = true;
                name = ShortNameGenerator.replaceInvalidChars(lfnName);
            } else {
                name = lfnName;
            }
            extension = "";
        } else {
            String tmp = lfnName.substring(0, periodIndex);
            if (ShortNameGenerator.containsInvalidChars(tmp)) {
                losslyConversion = true;
                name = ShortNameGenerator.replaceInvalidChars(lfnName);
            } else {
                name = tmp;
            }
            extension = ShortNameGenerator.replaceInvalidChars(lfnName.substring(periodIndex + 1));
            if (extension.length() > 3) {
                extension = extension.substring(0, 3);
            }
        }
        name = name.replace(" ", "");
        extension = extension.replace(" ", "");
        ShortName result = new ShortName(name, extension);
        if (losslyConversion || name.length() > 8 || existingShortNames.contains(result)) {
            String suffix;
            int suffixLen;
            String newName;
            int maxLen = Math.min(name.length(), 8);
            for (i = 1; i < 999999 && existingShortNames.contains(result = new ShortName(newName = name.substring(0, Math.min(maxLen, 8 - (suffixLen = (suffix = "~" + i).length()))) + suffix, extension)); ++i) {
            }
        }
        return result;
    }
}

