/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class FsInfoStructure {
    static int INVALID_VALUE = -1;
    private static int LEAD_SIGNATURE_OFF = 0;
    private static int STRUCT_SIGNATURE_OFF = 484;
    private static int TRAIL_SIGNATURE_OFF = 508;
    private static int FREE_COUNT_OFF = 488;
    private static int NEXT_FREE_OFFSET = 492;
    private static int LEAD_SIGNATURE = 1096897106;
    private static int STRUCT_SIGNATURE = 1631679090;
    private static int TRAIL_SIGNATURE = -1437270016;
    private static final String TAG = FsInfoStructure.class.getSimpleName();
    private int offset;
    private BlockDeviceDriver blockDevice;
    private ByteBuffer buffer;

    private FsInfoStructure(BlockDeviceDriver blockDevice, int offset) throws IOException {
        this.blockDevice = blockDevice;
        this.offset = offset;
        this.buffer = ByteBuffer.allocate(512);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        blockDevice.read(offset, this.buffer);
        this.buffer.clear();
        if (this.buffer.getInt(LEAD_SIGNATURE_OFF) != LEAD_SIGNATURE || this.buffer.getInt(STRUCT_SIGNATURE_OFF) != STRUCT_SIGNATURE || this.buffer.getInt(TRAIL_SIGNATURE_OFF) != TRAIL_SIGNATURE) {
            throw new IOException("invalid fs info structure!");
        }
    }

    static FsInfoStructure read(BlockDeviceDriver blockDevice, int offset) throws IOException {
        return new FsInfoStructure(blockDevice, offset);
    }

    void setFreeClusterCount(long value) {
        this.buffer.putInt(FREE_COUNT_OFF, (int)value);
    }

    long getFreeClusterCount() {
        return this.buffer.getInt(FREE_COUNT_OFF);
    }

    void setLastAllocatedClusterHint(long value) {
        this.buffer.putInt(NEXT_FREE_OFFSET, (int)value);
    }

    long getLastAllocatedClusterHint() {
        return this.buffer.getInt(NEXT_FREE_OFFSET);
    }

    void decreaseClusterCount(long numberOfClusters) {
        long freeClusterCount = this.getFreeClusterCount();
        if (freeClusterCount != (long)INVALID_VALUE) {
            this.setFreeClusterCount(freeClusterCount - numberOfClusters);
        }
    }

    void write() throws IOException {
        Log.d((String)TAG, (String)"writing to device");
        this.blockDevice.write(this.offset, this.buffer);
        this.buffer.clear();
    }
}

