/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.squidb.support;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import com.yahoo.squidb.data.AbstractModel;
import com.yahoo.squidb.data.SquidCursor;
import com.yahoo.squidb.data.SquidDatabase;
import com.yahoo.squidb.sql.Query;

public class SquidSupportCursorLoader<T extends AbstractModel>
extends AsyncTaskLoader<SquidCursor<T>> {
    private final Query query;
    private final SquidDatabase database;
    private Uri notificationUri = null;
    private SquidCursor<T> cursor = null;
    private final Class<T> modelClass;
    private final Loader.ForceLoadContentObserver observer = new Loader.ForceLoadContentObserver((Loader)this);

    public SquidSupportCursorLoader(Context context, SquidDatabase database, Class<T> modelClass, Query query) {
        super(context);
        this.database = database;
        this.query = query;
        this.modelClass = modelClass;
    }

    public void setNotificationUri(Uri uri) {
        this.notificationUri = uri;
    }

    public SquidCursor<T> loadInBackground() {
        SquidCursor result = this.database.query(this.modelClass, this.query);
        if (result != null) {
            result.getCount();
            Cursor androidResult = (Cursor)result.getCursor();
            androidResult.registerContentObserver((ContentObserver)this.observer);
            if (this.notificationUri != null) {
                androidResult.setNotificationUri(this.getContext().getContentResolver(), this.notificationUri);
            }
        }
        return result;
    }

    public void deliverResult(SquidCursor<T> data) {
        if (this.isReset()) {
            if (data != null) {
                data.close();
            }
            return;
        }
        SquidCursor<T> oldCursor = this.cursor;
        this.cursor = data;
        if (this.isStarted()) {
            super.deliverResult(data);
        }
        if (oldCursor != null && oldCursor != data && !oldCursor.isClosed()) {
            oldCursor.close();
        }
    }

    protected void onStartLoading() {
        if (this.cursor != null) {
            this.deliverResult(this.cursor);
        }
        if (this.takeContentChanged() || this.cursor == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(SquidCursor<T> data) {
        if (data != null && !data.isClosed()) {
            data.close();
        }
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.cursor != null && !this.cursor.isClosed()) {
            this.cursor.close();
        }
        this.cursor = null;
    }
}

