/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo.internal.di;

import com.miguelbcr.ui.rx_paparazzo.entities.Config;
import com.miguelbcr.ui.rx_paparazzo.entities.TargetUi;
import com.miguelbcr.ui.rx_paparazzo.interactors.CropImage;
import com.miguelbcr.ui.rx_paparazzo.interactors.DownloadImage;
import com.miguelbcr.ui.rx_paparazzo.interactors.GetDimens;
import com.miguelbcr.ui.rx_paparazzo.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo.interactors.GrantPermissions;
import com.miguelbcr.ui.rx_paparazzo.interactors.ImageUtils;
import com.miguelbcr.ui.rx_paparazzo.interactors.PickImage;
import com.miguelbcr.ui.rx_paparazzo.interactors.PickImages;
import com.miguelbcr.ui.rx_paparazzo.interactors.SaveImage;
import com.miguelbcr.ui.rx_paparazzo.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo.interactors.TakePhoto;
import com.miguelbcr.ui.rx_paparazzo.internal.di.ApplicationComponent;
import com.miguelbcr.ui.rx_paparazzo.workers.Camera;
import com.miguelbcr.ui.rx_paparazzo.workers.Gallery;

class ApplicationComponentImpl
extends ApplicationComponent {
    private final GetPath getPath;
    private final Camera camera;
    private final Gallery gallery;

    public ApplicationComponentImpl(TargetUi ui, Config config) {
        StartIntent startIntent = new StartIntent(ui);
        ImageUtils imageUtils = new ImageUtils(ui, config);
        DownloadImage downloadImage = new DownloadImage(ui, imageUtils);
        this.getPath = new GetPath(ui, downloadImage);
        TakePhoto takePhoto = new TakePhoto(startIntent, ui, imageUtils);
        GetDimens getDimens = new GetDimens(ui, config, this.getPath);
        CropImage cropImage = new CropImage(ui, config, startIntent, this.getPath, imageUtils);
        SaveImage saveImage = new SaveImage(ui, this.getPath, getDimens, imageUtils);
        GrantPermissions grantPermissions = new GrantPermissions(ui);
        PickImages pickImages = new PickImages(startIntent, this.getPath, ui);
        PickImage pickImage = new PickImage(startIntent, this.getPath);
        this.camera = new Camera(takePhoto, cropImage, saveImage, grantPermissions, ui, config);
        this.gallery = new Gallery(grantPermissions, pickImages, pickImage, cropImage, saveImage, ui, config);
    }

    @Override
    public Camera camera() {
        return this.camera;
    }

    @Override
    public Gallery gallery() {
        return this.gallery;
    }

    @Override
    public GetPath getPath() {
        return this.getPath;
    }
}

