/*
 * Decompiled with CFR 0.152.
 */
package com.miguelbcr.ui.rx_paparazzo.interactors;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.miguelbcr.ui.rx_paparazzo.interactors.GetPath;
import com.miguelbcr.ui.rx_paparazzo.interactors.StartIntent;
import com.miguelbcr.ui.rx_paparazzo.interactors.UseCase;
import java.io.File;
import rx.Observable;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx_activity_result.OnPreResult;

public final class PickImage
extends UseCase<Uri> {
    private final StartIntent startIntent;
    private final GetPath getPath;

    public PickImage(StartIntent startIntent, GetPath getPath) {
        this.startIntent = startIntent;
        this.getPath = getPath;
    }

    @Override
    public Observable<Uri> react() {
        return this.startIntent.with(this.getFileChooserIntent(), this.getOnPreResultProcessing()).react().map((Func1)new Func1<Intent, Uri>(){

            public Uri call(Intent intent) {
                return intent.getData();
            }
        });
    }

    private Intent getFileChooserIntent() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        return intent;
    }

    private OnPreResult getOnPreResultProcessing() {
        return new OnPreResult(){

            public Observable<String> response(int responseCode, final @Nullable Intent intent) {
                boolean dataExists;
                boolean bl = dataExists = intent != null && intent.getData() != null;
                if (responseCode == -1 && dataExists) {
                    return PickImage.this.getPath.with(intent.getData()).react().subscribeOn(Schedulers.io()).map((Func1)new Func1<String, String>(){

                        public String call(String filePath) {
                            intent.setData(Uri.fromFile((File)new File(filePath)));
                            return filePath;
                        }
                    }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends String>>(){

                        public Observable<? extends String> call(Throwable throwable) {
                            return Observable.just((Object)"");
                        }
                    });
                }
                return Observable.just((Object)"");
            }
        };
    }
}

