/*
 * Decompiled with CFR 0.152.
 */
package com.mynameismidori.currencypicker;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.MultiSelectListPreference;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mynameismidori.currencypicker.ExtendedCurrency;
import com.mynameismidori.currencypicker.MultiCurrencyListAdapter;
import com.mynameismidori.currencypicker.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MultiCurrencyPreference
extends MultiSelectListPreference {
    private EditText searchEditText;
    private ListView currencyListView;
    private CharSequence[] currencyName;
    private CharSequence[] currencyCode;
    private MultiCurrencyListAdapter adapter;
    private int currentIndex = 0;
    private List<ExtendedCurrency> currenciesList = new ArrayList<ExtendedCurrency>();
    private List<ExtendedCurrency> selectedCurrenciesList = new ArrayList<ExtendedCurrency>();
    SharedPreferences preferences;
    SharedPreferences.Editor editor;

    public MultiCurrencyPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setCurrenciesList(ExtendedCurrency.getAllCurrencies());
        this.preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.editor = this.preferences.edit();
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        Log.v((String)"VALUES", (String)this.getValues().toString());
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.currency_picker, null);
        this.searchEditText = (EditText)view.findViewById(R.id.currency_code_picker_search);
        this.currencyListView = (ListView)view.findViewById(R.id.currency_code_picker_listview);
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MultiCurrencyPreference.this.search(s.toString());
            }
        });
        LinearLayout linearLayout = (LinearLayout)view.findViewById(R.id.linear_layout);
        ListView currencyListView = (ListView)view.findViewById(R.id.currency_code_picker_listview);
        this.selectedCurrenciesList = new ArrayList<ExtendedCurrency>(this.currenciesList.size());
        this.selectedCurrenciesList.addAll(this.currenciesList);
        this.adapter = new MultiCurrencyListAdapter(this.getContext(), this.selectedCurrenciesList, this.getValues());
        currencyListView.setChoiceMode(2);
        currencyListView.setAdapter((ListAdapter)this.adapter);
        builder.setView(view);
        builder.setNegativeButton(null, null);
        builder.setPositiveButton((CharSequence)"Ok", null);
        this.currencyCode = this.getEntries();
        this.currencyName = this.getEntryValues();
        if (this.currencyName == null || this.currencyCode == null || this.currencyCode.length != this.currencyName.length) {
            throw new IllegalStateException("Preference requires an entries array and an entryValues array which are both the same length");
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        this.editor.putStringSet(this.getKey(), this.getValues());
        this.editor.commit();
        super.onDialogClosed(positiveResult);
    }

    @SuppressLint(value={"DefaultLocale"})
    private void search(String text) {
        this.selectedCurrenciesList.clear();
        for (ExtendedCurrency currency : this.currenciesList) {
            if (!currency.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase())) continue;
            this.selectedCurrenciesList.add(currency);
        }
        this.adapter.notifyDataSetChanged();
    }

    public void setCurrenciesList(List<ExtendedCurrency> newCurrencies) {
        this.currenciesList.clear();
        this.currenciesList.addAll(newCurrencies);
    }
}

