/*
 * Decompiled with CFR 0.152.
 */
package com.mynameismidori.currencypicker;

import android.content.Context;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.mynameismidori.currencypicker.ExtendedCurrency;
import com.mynameismidori.currencypicker.R;
import java.util.List;
import java.util.Set;

public class MultiCurrencyListAdapter
extends BaseAdapter
implements CompoundButton.OnCheckedChangeListener {
    private Context mContext;
    List<ExtendedCurrency> currencies;
    LayoutInflater inflater;
    Set<String> selectedCurrencies;
    private SparseBooleanArray checkedCurrencies;

    public MultiCurrencyListAdapter(Context context, List<ExtendedCurrency> currencies, Set<String> selectedCurrencies) {
        this.mContext = context;
        this.currencies = currencies;
        this.selectedCurrencies = selectedCurrencies;
        this.checkedCurrencies = new SparseBooleanArray(currencies.size());
        for (String code : selectedCurrencies) {
            int position = currencies.indexOf(ExtendedCurrency.getCurrencyByISO(code));
            this.checkedCurrencies.put(position, true);
        }
        this.inflater = LayoutInflater.from((Context)context);
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.setChecked((Integer)buttonView.getTag(), isChecked);
    }

    public boolean isChecked(int position) {
        return this.checkedCurrencies.get(position, false);
    }

    public void setChecked(int position, boolean isChecked) {
        this.checkedCurrencies.put(position, isChecked);
        if (isChecked) {
            this.selectedCurrencies.add(this.currencies.get(position).getCode());
        } else {
            this.selectedCurrencies.remove(this.currencies.get(position).getCode());
        }
    }

    public void toggle(int position) {
        this.setChecked(position, !this.isChecked(position));
    }

    public int getCount() {
        return this.currencies.size();
    }

    public Object getItem(int arg0) {
        return null;
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View view, ViewGroup parent) {
        ExtendedCurrency currency = this.currencies.get(position);
        if (view == null) {
            view = this.inflater.inflate(R.layout.row, null);
        }
        Cell cell = Cell.from(view);
        cell.textView.setText((CharSequence)currency.getName());
        cell.checkBox.setTag((Object)position);
        cell.checkBox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        cell.checkBox.setChecked(this.checkedCurrencies.get(position, false));
        currency.loadFlagByCode(this.mContext);
        if (currency.getFlag() != -1) {
            cell.imageView.setImageResource(currency.getFlag());
        }
        return view;
    }

    static class Cell {
        public TextView textView;
        public ImageView imageView;
        public CheckBox checkBox;

        Cell() {
        }

        static Cell from(View view) {
            if (view == null) {
                return null;
            }
            if (view.getTag() == null) {
                Cell cell = new Cell();
                cell.textView = (TextView)view.findViewById(R.id.row_title);
                cell.imageView = (ImageView)view.findViewById(R.id.row_icon);
                cell.checkBox = (CheckBox)view.findViewById(R.id.checkBox);
                cell.checkBox.setVisibility(0);
                view.setTag((Object)cell);
                return cell;
            }
            return (Cell)view.getTag();
        }
    }
}

