/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.ByteData;
import com.github.microwww.redis.database.DataLock;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.util.Assert;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class RedisDatabase
implements DataLock,
Closeable {
    ConcurrentMap<HashKey, AbstractValueData<?>> map = new ConcurrentHashMap();

    public void put(HashKey key, byte[] val) {
        this.map.put(key, new ByteData(val, -1L));
    }

    public AbstractValueData<?> put(HashKey key, AbstractValueData<?> data) {
        return this.map.put(key, data);
    }

    public synchronized <U, T extends AbstractValueData<U>> T putIfAbsent(HashKey key, T data) {
        AbstractValueData dt = (AbstractValueData)this.map.get(key);
        if (dt != null && dt.isExpired()) {
            this.map.remove(key, dt);
        }
        return (T)this.map.putIfAbsent(key, data);
    }

    public Optional<ByteData> getBytes(HashKey key) {
        return this.get(key, ByteData.class);
    }

    public <U, T extends AbstractValueData<U>> Optional<T> get(HashKey key, Class<T> clazz) {
        return this.get(key).map(e -> e);
    }

    public synchronized <U, T extends AbstractValueData<U>> T getOrCreate(HashKey key, Supplier<T> fun) {
        Optional<AbstractValueData<?>> opt = this.get(key);
        if (!opt.isPresent()) {
            AbstractValueData v = (AbstractValueData)fun.get();
            AbstractValueData t = this.putIfAbsent(key, v);
            opt = Optional.of(t == null ? v : t);
        }
        return (T)opt.get();
    }

    public synchronized Optional<AbstractValueData<?>> setExpire(HashKey key, long expire) {
        Assert.isTrue(expire >= 0L, "Time >= 0");
        Optional<AbstractValueData<?>> val = this.get(key);
        val.ifPresent(e -> {
            e.setExpire(expire);
            if (e.isExpired()) {
                this.remove(key);
            }
        });
        return val;
    }

    public Optional<AbstractValueData<?>> get(HashKey key) {
        AbstractValueData val = (AbstractValueData)this.map.get(key);
        if (val != null && val.isExpired()) {
            this.map.remove(key, val);
            return Optional.empty();
        }
        return Optional.ofNullable(val);
    }

    public Map<HashKey, AbstractValueData<?>> getUnmodifiableMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public int getMapSize() {
        return this.map.size();
    }

    public synchronized AbstractValueData<?> remove(HashKey key) {
        return (AbstractValueData)this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public void close() {
        this.map.clear();
    }
}

