/*
 * Decompiled with CFR 0.152.
 */
package com.gamemalt.pinview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gamemalt.pinview.PinViewListener;
import com.gamemalt.pinview.R;
import java.util.Arrays;
import java.util.Collections;

public class PinView
extends LinearLayout {
    private PinViewListener pinViewListener;
    private View mainLayout;
    private int pinButtonBackground;
    private int buttonClearBackground;
    private int buttonOkBackground;
    private int buttonTextColor;
    private int buttonTextSize;
    private ImageButton buttonClear;
    private ImageButton buttonOk;
    private boolean showOkButton;
    private boolean showClearButton;
    private boolean isHapticFeedBack = false;
    private TextView[] pinButtons = new TextView[10];
    boolean isEnabled = true;
    private View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (PinView.this.pinViewListener == null || !PinView.this.isEnabled) {
                return;
            }
            if (v.getId() == R.id.button_clear) {
                PinView.this.pinViewListener.onClearButtonClick();
            } else if (v.getId() == R.id.button_ok) {
                PinView.this.pinViewListener.onOkButtonClick();
            } else {
                PinView.this.pinViewListener.onPinButtonClick(Integer.parseInt(((TextView)v).getText().toString().trim()));
            }
            if (PinView.this.isHapticFeedBackEnabled() && v.getId() != R.id.button_ok) {
                PinView.this.vibrate();
            }
        }
    };

    public PinView(Context context) {
        super(context);
        this.setDefaultAttr(null);
        this.initView();
    }

    public PinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setDefaultAttr(attrs);
        this.initView();
    }

    public PinView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setDefaultAttr(attrs);
        this.initView();
    }

    private void setDefaultAttr(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PinView);
        try {
            this.buttonClearBackground = typedArray.getResourceId(R.styleable.PinView_buttonClearBackground, R.drawable.v_back);
            this.buttonOkBackground = typedArray.getResourceId(R.styleable.PinView_buttonOkBackground, R.drawable.v_tick);
            this.pinButtonBackground = typedArray.getResourceId(R.styleable.PinView_pinButtonBackground, 17170445);
            this.buttonTextColor = typedArray.getColor(R.styleable.PinView_buttonTextColor, -1);
            this.buttonTextSize = typedArray.getInt(R.styleable.PinView_buttonTextSize, 24);
            this.isHapticFeedBack = typedArray.getBoolean(R.styleable.PinView_isHapticFeedBack, false);
            this.showOkButton = typedArray.getBoolean(R.styleable.PinView_showOkButton, true);
            this.showClearButton = typedArray.getBoolean(R.styleable.PinView_showClearButton, true);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setListener(PinViewListener listener) {
        this.pinViewListener = listener;
    }

    private void initView() {
        this.mainLayout = PinView.inflate((Context)this.getContext(), (int)R.layout.pin_view, (ViewGroup)this);
        this.findAllViews();
        this.buttonClear.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (PinView.this.pinViewListener == null || !PinView.this.isEnabled) {
                    return true;
                }
                PinView.this.pinViewListener.onClearButtonLongClick();
                if (PinView.this.isHapticFeedBackEnabled()) {
                    PinView.this.vibrate();
                }
                return true;
            }
        });
        this.buttonClear.setOnClickListener(this.clickListener);
        this.buttonOk.setOnClickListener(this.clickListener);
        this.setShowClearButton(this.showClearButton);
        this.setShowOkButton(this.showOkButton);
    }

    private void findAllViews() {
        this.buttonClear = (ImageButton)this.findViewById(R.id.button_clear);
        this.buttonOk = (ImageButton)this.findViewById(R.id.button_ok);
        this.setButtonClearBackground(this.buttonClearBackground);
        this.setButtonOkBackground(this.buttonOkBackground);
        this.pinButtons[0] = (TextView)this.findViewById(R.id.button_0);
        this.pinButtons[1] = (TextView)this.findViewById(R.id.button_1);
        this.pinButtons[2] = (TextView)this.findViewById(R.id.button_2);
        this.pinButtons[3] = (TextView)this.findViewById(R.id.button_3);
        this.pinButtons[4] = (TextView)this.findViewById(R.id.button_4);
        this.pinButtons[5] = (TextView)this.findViewById(R.id.button_5);
        this.pinButtons[6] = (TextView)this.findViewById(R.id.button_6);
        this.pinButtons[7] = (TextView)this.findViewById(R.id.button_7);
        this.pinButtons[8] = (TextView)this.findViewById(R.id.button_8);
        this.pinButtons[9] = (TextView)this.findViewById(R.id.button_9);
        for (TextView button : this.pinButtons) {
            button.setOnClickListener(this.clickListener);
        }
        this.setPinButtonTextColor(this.buttonTextColor);
        this.setPinButtonTextSize(this.buttonTextSize);
    }

    public void shufflePinPad(boolean shouldShuffle) {
        Integer[] numArray = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        if (shouldShuffle) {
            Collections.shuffle(Arrays.asList(numArray));
        }
        for (int a = 0; a < this.pinButtons.length; ++a) {
            this.pinButtons[a].setText((CharSequence)String.valueOf(numArray[a]));
        }
    }

    private void vibrate() {
        this.performHapticFeedback(3, 3);
    }

    public void setPinButtonBackground(int pinButtonBackground) {
        this.pinButtonBackground = pinButtonBackground;
        for (TextView button : this.pinButtons) {
            button.setBackgroundResource(pinButtonBackground);
        }
    }

    public void setPinButtonTextColor(int pinButtonTextColor) {
        this.buttonTextColor = pinButtonTextColor;
        this.buttonClear.setColorFilter(pinButtonTextColor, PorterDuff.Mode.SRC_IN);
        this.buttonOk.setColorFilter(pinButtonTextColor, PorterDuff.Mode.SRC_IN);
        for (TextView button : this.pinButtons) {
            button.setTextColor(pinButtonTextColor);
        }
    }

    public void setPinButtonTextSize(int pinButtonTextSize) {
        this.buttonTextSize = pinButtonTextSize;
        for (TextView button : this.pinButtons) {
            button.setTextSize((float)pinButtonTextSize);
        }
    }

    public void setButtonClearBackground(int imageClearBackground) {
        this.buttonClearBackground = imageClearBackground;
        this.buttonClear.setImageResource(imageClearBackground);
    }

    public void setButtonOkBackground(int imageClearBackground) {
        this.buttonOkBackground = imageClearBackground;
        this.buttonOk.setImageResource(imageClearBackground);
    }

    public boolean isHapticFeedBackEnabled() {
        return this.isHapticFeedBack;
    }

    public void setHapticFeedBack(boolean isEnabled) {
        this.isHapticFeedBack = isEnabled;
    }

    public void setPinViewEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setShowOkButton(boolean shouldShow) {
        this.showOkButton = shouldShow;
        this.buttonOk.setVisibility(shouldShow ? 0 : 4);
    }

    public void setShowClearButton(boolean shouldShow) {
        this.showClearButton = shouldShow;
        this.buttonClear.setVisibility(shouldShow ? 0 : 4);
    }
}

