/*
 * Decompiled with CFR 0.152.
 */
package com.gamemalt.indicatordots;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.gamemalt.indicatordots.R;

public class CircleView
extends View {
    private Paint mpaint;
    private int dotColor;
    private int widthHeight;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CircleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleView);
        try {
            this.dotColor = typedArray.getColor(R.styleable.CircleView_dot_color, this.getContext().getResources().getColor(R.color.white));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            typedArray.recycle();
        }
        this.init();
    }

    public CircleView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mpaint = new Paint();
        this.mpaint.setStyle(Paint.Style.FILL);
        this.mpaint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getWidth();
        int h = this.getHeight();
        float ox = (float)w / 2.0f;
        float oy = (float)h / 2.0f;
        this.mpaint.setColor(this.dotColor);
        canvas.drawCircle(ox, oy, (float)this.getWidth() / 2.0f, this.mpaint);
    }

    public int getWidthHeight() {
        return this.widthHeight;
    }

    public void setWidthHeight(int widthHeight) {
        this.widthHeight = widthHeight;
    }

    public int getDotColor() {
        return this.dotColor;
    }

    public void setDotColor(int dotColor) {
        this.dotColor = dotColor;
        this.invalidate();
    }
}

