/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

import com.github.miachm.sods.Pair;

class A1NotationCord {
    private String a1Notation;
    private Pair<Integer, Integer> origen;
    private Pair<Integer, Integer> dest;

    A1NotationCord(String a1Notation) {
        if (a1Notation == null) {
            throw new NullPointerException("a1Notation can not be null");
        }
        if (a1Notation.isEmpty()) {
            throw new IllegalArgumentException("a1Notation can not be empty");
        }
        this.a1Notation = a1Notation;
        this.parse();
    }

    private void parse() {
        String[] parts = this.a1Notation.split(":");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Only a symbol ':' is allowed in a1Notation. Input: " + this.a1Notation);
        }
        this.origen = this.parsePart(parts[0]);
        if (parts.length == 2) {
            this.dest = this.parsePart(parts[1]);
            this.normalize();
        } else {
            this.dest = this.origen;
        }
    }

    private void normalize() {
        int aux;
        if ((Integer)this.dest.first < (Integer)this.origen.first) {
            aux = (Integer)this.dest.first;
            this.dest.first = this.origen.first;
            this.origen.first = aux;
        }
        if ((Integer)this.dest.second < (Integer)this.origen.second) {
            aux = (Integer)this.dest.second;
            this.dest.second = this.origen.second;
            this.origen.second = aux;
        }
    }

    private Pair<Integer, Integer> parsePart(String part) {
        int row = 0;
        int column = 0;
        int multRow = 1;
        int multColumn = 1;
        for (int i = part.length() - 1; i >= 0; --i) {
            int num;
            char letter = part.charAt(i);
            if (Character.isAlphabetic(letter)) {
                num = letter - 65;
                column += multColumn * (num + 1);
                multColumn *= 26;
                continue;
            }
            if (Character.isDigit(letter)) {
                num = letter - 48;
                row += multRow * num;
                multRow *= 10;
                continue;
            }
            throw new IllegalArgumentException("Invalid character found: '" + letter + "' at position " + i);
        }
        return new Pair<Integer, Integer>(--row, --column);
    }

    int getInitRow() {
        return (Integer)this.origen.first;
    }

    int getInitColumn() {
        return (Integer)this.origen.second;
    }

    int getLastRow() {
        return (Integer)this.dest.first;
    }

    int getLastColumn() {
        return (Integer)this.dest.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        A1NotationCord that = (A1NotationCord)o;
        return this.a1Notation.equals(that.a1Notation);
    }

    public int hashCode() {
        return this.a1Notation.hashCode();
    }
}

