/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.io.UnsupportedEncodingException;
import org.jivesoftware.smack.bosh.MessageBodyDecoder;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class EceToXmppIncomingMessageConverter {
    private MessageBodyDecoder decoder;
    private static final StanzaFilter ECE_INCOMING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.CHAT, MessageWithBodiesFilter.INSTANCE, FromTypeFilter.DOMAIN_BARE_JID});

    public EceToXmppIncomingMessageConverter(MessageBodyDecoder decoder) {
        this.decoder = decoder;
    }

    public void modifyIncomingChatMessage(Stanza packet) throws UnsupportedEncodingException {
        Message message = (Message)packet;
        EceToXmppIncomingMessageConverter.fixFromField(message);
        this.convertCharactersInBody(message);
    }

    private void convertCharactersInBody(Message message) throws UnsupportedEncodingException {
        String text = message.getBody();
        message.getBodies().forEach(f -> message.removeBody(f));
        message.setBody(this.decoder.decode(text));
    }

    private static void fixFromField(Message message) {
        Jid from = message.getFrom();
        if (!from.isEntityFullJid()) {
            EntityFullJid bareFrom;
            try {
                bareFrom = JidCreate.entityFullFrom((String)EceToXmppIncomingMessageConverter.convertEceIdToFullJid(from));
            }
            catch (XmppStringprepException e) {
                throw new RuntimeException(e);
            }
            message.setFrom((Jid)bareFrom);
        }
    }

    private static String convertEceIdToFullJid(Jid from) {
        return from.toString().replace(" ", "_") + "@egain.com/xyz";
    }

    public void process(Stanza packet) {
        if (ECE_INCOMING_MESSAGE_FILTER.accept(packet)) {
            try {
                this.modifyIncomingChatMessage(packet);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

